/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.util.LanguageTags;

public class PDFStructElem
extends PDFDictionary
implements StructureTreeElement,
CompressedObject {
    private PDFStructElem parentElement;
    protected List<PDFObject> kids;

    PDFStructElem(PDFObject parent, PDFName structureType) {
        if (parent instanceof PDFStructElem) {
            this.parentElement = (PDFStructElem)parent;
        }
        this.put("S", structureType);
        this.setParent(parent);
    }

    public PDFStructElem getParentStructElem() {
        return this.parentElement;
    }

    public void setParent(PDFObject parent) {
        if (parent != null && parent.hasObjectNumber()) {
            this.put("P", new PDFReference(parent));
        }
    }

    public void addKid(PDFObject kid) {
        if (this.kids == null) {
            this.kids = new ArrayList<PDFObject>();
        }
        this.kids.add(kid);
    }

    public void setMCIDKid(int mcid) {
        this.put("K", mcid);
    }

    public void setPage(PDFPage page) {
        this.put("Pg", page);
    }

    public PDFName getStructureType() {
        return (PDFName)this.get("S");
    }

    private void setLanguage(String language) {
        this.put("Lang", language);
    }

    public void setLanguage(Locale language) {
        this.setLanguage(LanguageTags.toLanguageTag((Locale)language));
    }

    public String getLanguage() {
        return (String)this.get("Lang");
    }

    protected void writeDictionary(OutputStream out, StringBuilder textBuffer) throws IOException {
        this.attachKids();
        super.writeDictionary(out, textBuffer);
    }

    protected boolean attachKids() {
        boolean kidsAttached;
        ArrayList<PDFObject> validKids = new ArrayList<PDFObject>();
        if (this.kids != null) {
            for (PDFObject kid : this.kids) {
                if (kid instanceof Placeholder) {
                    if (!((Placeholder)kid).attachKids()) continue;
                    validKids.add(kid);
                    continue;
                }
                validKids.add(kid);
            }
        }
        boolean bl = kidsAttached = !validKids.isEmpty();
        if (kidsAttached) {
            PDFArray array = new PDFArray();
            for (PDFObject ob : validKids) {
                array.add(ob);
            }
            this.put("K", array);
        }
        return kidsAttached;
    }

    public static class Placeholder
    extends PDFStructElem {
        public void outputInline(OutputStream out, StringBuilder textBuffer) throws IOException {
            if (this.kids != null) {
                assert (this.kids.size() > 0);
                for (int i = 0; i < this.kids.size(); ++i) {
                    if (i > 0) {
                        textBuffer.append(' ');
                    }
                    Object obj = this.kids.get(i);
                    this.formatObject(obj, out, textBuffer);
                }
            }
        }

        public Placeholder(PDFObject parent, String name) {
            super(parent, new PDFName(name));
        }
    }
}

