/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicIncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedIncrementTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class IncrementTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtUnaryExpression expression;
    @NotNull
    protected final AccessTranslator accessTranslator;

    public static boolean isIncrement(IElementType operationToken) {
        return OperatorConventions.INCREMENT_OPERATIONS.contains(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression) || IncrementTranslator.isDynamic(context, expression)) {
            JsExpression jsExpression = IntrinsicIncrementTranslator.doTranslate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = new OverloadedIncrementTranslator(expression, context).translateIncrementExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
        }
        return jsExpression;
    }

    protected IncrementTranslator(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression);
        this.accessTranslator = AccessTranslationUtils.getAccessTranslator(baseExpression, this.context()).getCached();
    }

    @NotNull
    protected JsExpression translateIncrementExpression() {
        if (PsiUtils.isPrefix(this.expression)) {
            JsExpression jsExpression = this.asPrefix();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translateIncrementExpression"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.asPostfix();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translateIncrementExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression asPrefix() {
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        JsExpression reassignment = this.variableReassignment(getExpression);
        JsExpression getNewValue = this.accessTranslator.translateAsGet();
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.COMMA, reassignment, getNewValue);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "asPrefix"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression asPostfix() {
        TemporaryVariable t1 = this.context().declareTemporary(this.accessTranslator.translateAsGet());
        TemporaryVariable t2 = this.context().declareTemporary(t1.reference());
        JsExpression variableReassignment = this.variableReassignment(t1.reference());
        JsBinaryOperation jsBinaryOperation = AstUtil.newSequence(t1.assignmentExpression(), t2.assignmentExpression(), variableReassignment, t2.reference());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "asPostfix"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression variableReassignment(@NotNull JsExpression toCallMethodUpon) {
        if (toCallMethodUpon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCallMethodUpon", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "variableReassignment"));
        }
        JsExpression overloadedMethodCallOnPropertyGetter = this.operationExpression(toCallMethodUpon);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(overloadedMethodCallOnPropertyGetter);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "variableReassignment"));
        }
        return jsExpression;
    }

    @NotNull
    abstract JsExpression operationExpression(@NotNull JsExpression var1);

    private static boolean isDynamic(TranslationContext context, KtUnaryExpression expression) {
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        return DynamicCallsKt.isDynamic(operationDescriptor);
    }
}

