/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.load.kotlin.JvmDescriptorTypeWriter;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000b\u001a/\u0010\f\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u001as\u0010\u0013\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\r0\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\u001b2 \b\u0002\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\u0010\u001f\u001a1\u0010 \u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010!\u001a\u0002H\r2\u0006\u0010\"\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010#\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"NON_EXISTENT_CLASS_NAME", "", "computeInternalName", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getRepresentativeUpperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "hasVoidReturnType", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "mapBuiltInType", "T", "", "type", "typeFactory", "Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;)Ljava/lang/Object;", "mapType", "kotlinType", "factory", "mode", "Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;", "typeMappingConfiguration", "Lorg/jetbrains/kotlin/load/kotlin/TypeMappingConfiguration;", "descriptorTypeWriter", "Lorg/jetbrains/kotlin/load/kotlin/JvmDescriptorTypeWriter;", "writeGenericType", "Lkotlin/Function3;", "", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;Lorg/jetbrains/kotlin/load/kotlin/TypeMappingConfiguration;Lorg/jetbrains/kotlin/load/kotlin/JvmDescriptorTypeWriter;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "boxTypeIfNeeded", "possiblyPrimitiveType", "needBoxedType", "(Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;Ljava/lang/Object;Z)Ljava/lang/Object;", "kotlin-compiler"})
public final class TypeSignatureMappingKt {
    @NotNull
    public static final String NON_EXISTENT_CLASS_NAME = "error/NonExistentClass";

    private static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $receiver, T possiblyPrimitiveType, boolean needBoxedType) {
        return needBoxedType ? $receiver.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        Intrinsics.checkParameterIsNotNull(factory, "factory");
        Intrinsics.checkParameterIsNotNull(mode, "mode");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        Intrinsics.checkParameterIsNotNull(writeGenericType, "writeGenericType");
        T t = TypeSignatureMappingKt.mapBuiltInType(kotlinType, factory);
        if (t != null) {
            T t2 = t;
            T builtInType = t2;
            T jvmType = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            Collection<KotlinType> collection = ((IntersectionTypeConstructor)constructor).getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "constructor.supertypes");
            KotlinType commonSupertype = typeMappingConfiguration.commonSupertype(collection);
            return TypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(descriptor2)) {
            T jvmType = factory.createObjectType(NON_EXISTENT_CLASS_NAME);
            ClassifierDescriptor classifierDescriptor2 = descriptor2;
            if (classifierDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)classifierDescriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            T arrayElementType;
            if (kotlinType.getArguments().size() != 1) {
                throw (Throwable)new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType memberType = memberProjection.getType();
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    void $receiver;
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2 = jvmDescriptorTypeWriter;
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = jvmDescriptorTypeWriter2;
                    $receiver.writeArrayType();
                    $receiver.writeClass(arrayElementType);
                    $receiver.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    jvmDescriptorTypeWriter.writeArrayType();
                }
                KotlinType kotlinType2 = memberType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "memberType");
                Variance variance = memberProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "memberProjection.projectionKind");
                arrayElementType = TypeSignatureMappingKt.mapType(kotlinType2, factory, mode.toGenericArgumentMode(variance), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter4 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter4 != null) {
                    jvmDescriptorTypeWriter4.writeArrayEnd();
                }
            }
            return factory.createFromString("[" + factory.toString(arrayElementType));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            T t3;
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                t3 = factory.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.original");
                t3 = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                if (t3 == null) {
                    ClassDescriptor classDescriptor2 = ((ClassDescriptor)descriptor2).getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "descriptor.original");
                    t3 = factory.createObjectType(TypeSignatureMappingKt.computeInternalName(classDescriptor2));
                }
            }
            T jvmType = t3;
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "descriptor");
            JvmDescriptorTypeWriter jvmDescriptorTypeWriter = null;
            Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = TypeSignatureMappingKt.mapType(TypeSignatureMappingKt.getRepresentativeUpperBound(typeParameterDescriptor), factory, mode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter5 = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter5 != null) {
                Name name = descriptor2.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
                jvmDescriptorTypeWriter5.writeTypeVariable(name, type2);
            }
            return (T)type2;
        }
        throw (Throwable)new UnsupportedOperationException("Unknown type " + kotlinType);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: mapType");
        }
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return TypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    private static final <T> T mapBuiltInType(KotlinType type2, JvmTypeFactory<T> typeFactory) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        FqNameUnsafe fqName2 = DescriptorUtilsKt.getFqNameUnsafe(descriptor2);
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveTypeByFqName(fqName2);
        if (primitiveType != null) {
            String string = JvmPrimitiveType.get(primitiveType).getDesc();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmPrimitiveType.get(primitiveType).desc");
            T jvmType = typeFactory.createFromString(string);
            boolean isNullableInJava = TypeUtils.isNullableType(type2) || TypeEnhancementKt.hasEnhancedNullability(type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveTypeByArrayClassFqName(fqName2);
        if (arrayElementType != null) {
            return typeFactory.createFromString("[" + JvmPrimitiveType.get(arrayElementType).getDesc());
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2);
        if (classId != null) {
            String string = JvmClassName.byClassId(classId).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(classId).internalName");
            return typeFactory.createObjectType(string);
        }
        return null;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        DeclarationDescriptor container = klass.getContainingDeclaration();
        String name = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        if (container instanceof PackageFragmentDescriptor) {
            String string;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                String string2 = name;
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull(string2, "name");
            } else {
                string = StringsKt.replace$default(fqName2.asString(), '.', '/', false, 4, null) + '/' + name;
            }
            return string;
        }
        boolean fqName2 = container instanceof ClassDescriptor;
        if (_Assertions.ENABLED && !fqName2) {
            String string = "Unexpected container: " + container + " for " + klass;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        String containerInternalName = TypeSignatureMappingKt.computeInternalName((ClassDescriptor)declarationDescriptor);
        return Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.ENUM_ENTRY) ? containerInternalName : containerInternalName + "$" + name;
    }

    private static final KotlinType getRepresentativeUpperBound(TypeParameterDescriptor descriptor2) {
        KotlinType kotlinType;
        Object v2;
        List<KotlinType> upperBounds;
        block4: {
            upperBounds = descriptor2.getUpperBounds();
            boolean bl = !upperBounds.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Upper bounds should not be empty: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = upperBounds;
            for (Object element$iv : $receiver$iv) {
                ClassDescriptor classDescriptor;
                KotlinType it = (KotlinType)element$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                boolean bl2 = (ClassDescriptor)classifierDescriptor == null ? false : Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE) ^ true && Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ANNOTATION_CLASS) ^ true;
                if (!bl2) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        if ((kotlinType = (KotlinType)v2) == null) {
            KotlinType kotlinType2 = CollectionsKt.first(upperBounds);
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "upperBounds.first()");
        }
        return kotlinType;
    }
}

