/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import sun.security.provider.PolicyParser;
import sun.security.tools.policytool.AWTPerm;
import sun.security.tools.policytool.AddEntryDoneButtonListener;
import sun.security.tools.policytool.AddPermButtonListener;
import sun.security.tools.policytool.AddPrinButtonListener;
import sun.security.tools.policytool.AllPerm;
import sun.security.tools.policytool.AudioPerm;
import sun.security.tools.policytool.AuthPerm;
import sun.security.tools.policytool.CancelButtonListener;
import sun.security.tools.policytool.ChangeKeyStoreOKButtonListener;
import sun.security.tools.policytool.ChildWindowListener;
import sun.security.tools.policytool.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.policytool.DelegationPerm;
import sun.security.tools.policytool.EditPermButtonListener;
import sun.security.tools.policytool.EditPrinButtonListener;
import sun.security.tools.policytool.FilePerm;
import sun.security.tools.policytool.InqSecContextPerm;
import sun.security.tools.policytool.KrbPrin;
import sun.security.tools.policytool.LogPerm;
import sun.security.tools.policytool.MBeanPerm;
import sun.security.tools.policytool.MBeanSvrPerm;
import sun.security.tools.policytool.MBeanTrustPerm;
import sun.security.tools.policytool.MgmtPerm;
import sun.security.tools.policytool.NetPerm;
import sun.security.tools.policytool.NewPolicyPermOKButtonListener;
import sun.security.tools.policytool.NewPolicyPrinOKButtonListener;
import sun.security.tools.policytool.NoDisplayException;
import sun.security.tools.policytool.Perm;
import sun.security.tools.policytool.PermissionActionsMenuListener;
import sun.security.tools.policytool.PermissionMenuListener;
import sun.security.tools.policytool.PermissionNameMenuListener;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.PolicyListListener;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.Prin;
import sun.security.tools.policytool.PrincipalTypeMenuListener;
import sun.security.tools.policytool.PrivCredPerm;
import sun.security.tools.policytool.PropPerm;
import sun.security.tools.policytool.ReflectPerm;
import sun.security.tools.policytool.RemovePermButtonListener;
import sun.security.tools.policytool.RemovePrinButtonListener;
import sun.security.tools.policytool.RuntimePerm;
import sun.security.tools.policytool.SQLPerm;
import sun.security.tools.policytool.SSLPerm;
import sun.security.tools.policytool.SecurityPerm;
import sun.security.tools.policytool.SerialPerm;
import sun.security.tools.policytool.ServicePerm;
import sun.security.tools.policytool.SocketPerm;
import sun.security.tools.policytool.SubjDelegPerm;
import sun.security.tools.policytool.TaggedList;
import sun.security.tools.policytool.ToolWindow;
import sun.security.tools.policytool.URLPerm;
import sun.security.tools.policytool.UserSaveNoButtonListener;
import sun.security.tools.policytool.UserSaveYesButtonListener;
import sun.security.tools.policytool.X500Prin;

class ToolDialog
extends JDialog {
    private static final long serialVersionUID = -372244357011301190L;
    static final KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
    public static final int NOACTION = 0;
    public static final int QUIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final String ALL_PERM_CLASS = "java.security.AllPermission";
    public static final String FILE_PERM_CLASS = "java.io.FilePermission";
    public static final String X500_PRIN_CLASS = "javax.security.auth.x500.X500Principal";
    public static final String PERM = PolicyTool.getMessage("Permission.");
    public static final String PRIN_TYPE = PolicyTool.getMessage("Principal.Type.");
    public static final String PRIN_NAME = PolicyTool.getMessage("Principal.Name.");
    public static final String PERM_NAME = PolicyTool.getMessage("Target.Name.");
    public static final String PERM_ACTIONS = PolicyTool.getMessage("Actions.");
    public static final int PE_CODEBASE_LABEL = 0;
    public static final int PE_CODEBASE_TEXTFIELD = 1;
    public static final int PE_SIGNEDBY_LABEL = 2;
    public static final int PE_SIGNEDBY_TEXTFIELD = 3;
    public static final int PE_PANEL0 = 4;
    public static final int PE_ADD_PRIN_BUTTON = 0;
    public static final int PE_EDIT_PRIN_BUTTON = 1;
    public static final int PE_REMOVE_PRIN_BUTTON = 2;
    public static final int PE_PRIN_LABEL = 5;
    public static final int PE_PRIN_LIST = 6;
    public static final int PE_PANEL1 = 7;
    public static final int PE_ADD_PERM_BUTTON = 0;
    public static final int PE_EDIT_PERM_BUTTON = 1;
    public static final int PE_REMOVE_PERM_BUTTON = 2;
    public static final int PE_PERM_LIST = 8;
    public static final int PE_PANEL2 = 9;
    public static final int PE_CANCEL_BUTTON = 1;
    public static final int PE_DONE_BUTTON = 0;
    public static final int PRD_DESC_LABEL = 0;
    public static final int PRD_PRIN_CHOICE = 1;
    public static final int PRD_PRIN_TEXTFIELD = 2;
    public static final int PRD_NAME_LABEL = 3;
    public static final int PRD_NAME_TEXTFIELD = 4;
    public static final int PRD_CANCEL_BUTTON = 6;
    public static final int PRD_OK_BUTTON = 5;
    public static final int PD_DESC_LABEL = 0;
    public static final int PD_PERM_CHOICE = 1;
    public static final int PD_PERM_TEXTFIELD = 2;
    public static final int PD_NAME_CHOICE = 3;
    public static final int PD_NAME_TEXTFIELD = 4;
    public static final int PD_ACTIONS_CHOICE = 5;
    public static final int PD_ACTIONS_TEXTFIELD = 6;
    public static final int PD_SIGNEDBY_LABEL = 7;
    public static final int PD_SIGNEDBY_TEXTFIELD = 8;
    public static final int PD_CANCEL_BUTTON = 10;
    public static final int PD_OK_BUTTON = 9;
    public static final int EDIT_KEYSTORE = 0;
    public static final int KSD_NAME_LABEL = 0;
    public static final int KSD_NAME_TEXTFIELD = 1;
    public static final int KSD_TYPE_LABEL = 2;
    public static final int KSD_TYPE_TEXTFIELD = 3;
    public static final int KSD_PROVIDER_LABEL = 4;
    public static final int KSD_PROVIDER_TEXTFIELD = 5;
    public static final int KSD_PWD_URL_LABEL = 6;
    public static final int KSD_PWD_URL_TEXTFIELD = 7;
    public static final int KSD_CANCEL_BUTTON = 9;
    public static final int KSD_OK_BUTTON = 8;
    public static final int USC_LABEL = 0;
    public static final int USC_PANEL = 1;
    public static final int USC_YES_BUTTON = 0;
    public static final int USC_NO_BUTTON = 1;
    public static final int USC_CANCEL_BUTTON = 2;
    public static final int CRPE_LABEL1 = 0;
    public static final int CRPE_LABEL2 = 1;
    public static final int CRPE_PANEL = 2;
    public static final int CRPE_PANEL_OK = 0;
    public static final int CRPE_PANEL_CANCEL = 1;
    private static final int PERMISSION = 0;
    private static final int PERMISSION_NAME = 1;
    private static final int PERMISSION_ACTIONS = 2;
    private static final int PERMISSION_SIGNEDBY = 3;
    private static final int PRINCIPAL_TYPE = 4;
    private static final int PRINCIPAL_NAME = 5;
    static final int TEXTFIELD_HEIGHT = new JComboBox<E>().getPreferredSize().height;
    public static ArrayList<Perm> PERM_ARRAY = new ArrayList();
    public static ArrayList<Prin> PRIN_ARRAY;
    PolicyTool tool;
    ToolWindow tw;

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, boolean bl) {
        super((Frame)toolWindow, bl);
        this.setTitle(string);
        this.tool = policyTool;
        this.tw = toolWindow;
        this.addWindowListener(new ChildWindowListener(this));
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(6, 6, 6, 6));
    }

    @Override
    public Component getComponent(int n) {
        Component component = this.getContentPane().getComponent(n);
        if (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getView();
        }
        return component;
    }

    static Perm getPerm(String string, boolean bl) {
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            Perm perm = PERM_ARRAY.get(i);
            if (!(bl ? perm.FULL_CLASS.equals(string) : perm.CLASS.equals(string))) continue;
            return perm;
        }
        return null;
    }

    static Prin getPrin(String string, boolean bl) {
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            Prin prin = PRIN_ARRAY.get(i);
            if (!(bl ? prin.FULL_CLASS.equals(string) : prin.CLASS.equals(string))) continue;
            return prin;
        }
        return null;
    }

    void displayPolicyEntryDialog(boolean bl) {
        Object object;
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        JComponent jComponent;
        int n = 0;
        PolicyEntry[] policyEntryArray = null;
        TaggedList taggedList = new TaggedList(3, false);
        taggedList.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Principal.List"));
        taggedList.addMouseListener(new EditPrinButtonListener(this.tool, this.tw, this, bl));
        TaggedList taggedList2 = new TaggedList(10, false);
        taggedList2.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Permission.List"));
        taggedList2.addMouseListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        Point point = this.tw.getLocationOnScreen();
        this.setLayout(new GridBagLayout());
        this.setResizable(true);
        if (bl) {
            policyEntryArray = this.tool.getEntry();
            jComponent = (JList)this.tw.getComponent(3);
            n = ((JList)jComponent).getSelectedIndex();
            serializable2 = policyEntryArray[n].getGrantEntry().principals;
            for (int i = 0; i < ((LinkedList)serializable2).size(); ++i) {
                Object var10_11 = null;
                object2 = (PolicyParser.PrincipalEntry)((LinkedList)serializable2).get(i);
                taggedList.addTaggedItem(ToolDialog.PrincipalEntryToUserFriendlyString((PolicyParser.PrincipalEntry)object2), object2);
            }
            serializable = policyEntryArray[n].getGrantEntry().permissionEntries;
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                object2 = null;
                object = ((Vector)serializable).elementAt(i);
                taggedList2.addTaggedItem(ToolDialog.PermissionEntryToUserFriendlyString((PolicyParser.PermissionEntry)object), object);
            }
        }
        jComponent = new JLabel();
        this.tw.addNewComponent(this, jComponent, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.R_PADDING);
        serializable2 = bl ? new JTextField(policyEntryArray[n].getGrantEntry().codeBase) : new JTextField();
        ToolWindow.configureLabelFor((JLabel)jComponent, serializable2, "CodeBase.");
        ((JComponent)serializable2).setPreferredSize(new Dimension(((JTextField)serializable2).getPreferredSize().width, TEXTFIELD_HEIGHT));
        ((JTextField)serializable2).getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Code.Base"));
        this.tw.addNewComponent(this, (JComponent)serializable2, 1, 1, 0, 1, 1, 1.0, 0.0, 1);
        jComponent = new JLabel();
        this.tw.addNewComponent(this, jComponent, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.R_PADDING);
        serializable2 = bl ? new JTextField(policyEntryArray[n].getGrantEntry().signedBy) : new JTextField();
        ToolWindow.configureLabelFor((JLabel)jComponent, (JComponent)serializable2, "SignedBy.");
        ((JComponent)serializable2).setPreferredSize(new Dimension(((JTextField)serializable2).getPreferredSize().width, TEXTFIELD_HEIGHT));
        ((JTextField)serializable2).getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Signed.By."));
        this.tw.addNewComponent(this, (JComponent)serializable2, 3, 1, 1, 1, 1, 1.0, 0.0, 1);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        JButton jButton = new JButton();
        ToolWindow.configureButton(jButton, "Add.Principal");
        jButton.addActionListener(new AddPrinButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton();
        ToolWindow.configureButton(jButton, "Edit.Principal");
        jButton.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton();
        ToolWindow.configureButton(jButton, "Remove.Principal");
        jButton.addActionListener(new RemovePrinButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, (JComponent)serializable, 4, 1, 2, 1, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        jComponent = new JLabel();
        this.tw.addNewComponent(this, jComponent, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
        object2 = new JScrollPane(taggedList);
        ToolWindow.configureLabelFor((JLabel)jComponent, (JComponent)object2, "Principals.");
        this.tw.addNewComponent(this, (JComponent)object2, 6, 1, 3, 3, 1, 0.0, taggedList.getVisibleRowCount(), 1, ToolWindow.BOTTOM_PADDING);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        jButton = new JButton();
        ToolWindow.configureButton(jButton, ".Add.Permission");
        jButton.addActionListener(new AddPermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton();
        ToolWindow.configureButton(jButton, ".Edit.Permission");
        jButton.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton();
        ToolWindow.configureButton(jButton, "Remove.Permission");
        jButton.addActionListener(new RemovePermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, (JComponent)serializable, 7, 0, 4, 2, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        object2 = new JScrollPane(taggedList2);
        this.tw.addNewComponent(this, (JComponent)object2, 8, 0, 5, 3, 1, 0.0, taggedList2.getVisibleRowCount(), 1, ToolWindow.BOTTOM_PADDING);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        object = new JButton(PolicyTool.getMessage("Done"));
        ((AbstractButton)object).addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, (JComponent)object, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        JButton jButton2 = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelButtonListener = new CancelButtonListener(this);
        jButton2.addActionListener(cancelButtonListener);
        this.tw.addNewComponent((Container)serializable, jButton2, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, (JComponent)serializable, 9, 0, 6, 2, 1, 0.0, 0.0, 3);
        this.getRootPane().setDefaultButton((JButton)object);
        this.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
        this.pack();
        this.setLocationRelativeTo(this.tw);
        this.setVisible(true);
    }

    PolicyEntry getPolicyEntryFromDialog() throws InvalidParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        JTextField jTextField = (JTextField)this.getComponent(1);
        String string = null;
        if (!jTextField.getText().trim().equals("")) {
            string = new String(jTextField.getText().trim());
        }
        jTextField = (JTextField)this.getComponent(3);
        String string2 = null;
        if (!jTextField.getText().trim().equals("")) {
            string2 = new String(jTextField.getText().trim());
        }
        PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(string2, string);
        LinkedList<PolicyParser.PrincipalEntry> linkedList = new LinkedList<PolicyParser.PrincipalEntry>();
        TaggedList taggedList = (TaggedList)this.getComponent(6);
        for (int i = 0; i < taggedList.getModel().getSize(); ++i) {
            linkedList.add((PolicyParser.PrincipalEntry)taggedList.getObject(i));
        }
        grantEntry.principals = linkedList;
        Vector<PolicyParser.PermissionEntry> vector = new Vector<PolicyParser.PermissionEntry>();
        TaggedList taggedList2 = (TaggedList)this.getComponent(8);
        for (int i = 0; i < taggedList2.getModel().getSize(); ++i) {
            vector.addElement((PolicyParser.PermissionEntry)taggedList2.getObject(i));
        }
        grantEntry.permissionEntries = vector;
        PolicyEntry policyEntry = new PolicyEntry(this.tool, grantEntry);
        return policyEntry;
    }

    void keyStoreDialog(int n) {
        Point point = this.tw.getLocationOnScreen();
        this.setLayout(new GridBagLayout());
        if (n == 0) {
            JLabel jLabel = new JLabel();
            this.tw.addNewComponent(this, jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            JTextField jTextField = new JTextField(this.tool.getKeyStoreName(), 30);
            ToolWindow.configureLabelFor(jLabel, jTextField, "KeyStore.URL.");
            jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
            jTextField.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.U.R.L."));
            this.tw.addNewComponent(this, jTextField, 1, 1, 0, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            jLabel = new JLabel();
            this.tw.addNewComponent(this, jLabel, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            jTextField = new JTextField(this.tool.getKeyStoreType(), 30);
            ToolWindow.configureLabelFor(jLabel, jTextField, "KeyStore.Type.");
            jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
            jTextField.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.Type."));
            this.tw.addNewComponent(this, jTextField, 3, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            jLabel = new JLabel();
            this.tw.addNewComponent(this, jLabel, 4, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            jTextField = new JTextField(this.tool.getKeyStoreProvider(), 30);
            ToolWindow.configureLabelFor(jLabel, jTextField, "KeyStore.Provider.");
            jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
            jTextField.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.Provider."));
            this.tw.addNewComponent(this, jTextField, 5, 1, 2, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            jLabel = new JLabel();
            this.tw.addNewComponent(this, jLabel, 6, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            jTextField = new JTextField(this.tool.getKeyStorePwdURL(), 30);
            ToolWindow.configureLabelFor(jLabel, jTextField, "KeyStore.Password.URL.");
            jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
            jTextField.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.Password.U.R.L."));
            this.tw.addNewComponent(this, jTextField, 7, 1, 3, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            JButton jButton = new JButton(PolicyTool.getMessage("OK"));
            jButton.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
            this.tw.addNewComponent(this, jButton, 8, 0, 4, 1, 1, 0.0, 0.0, 3);
            JButton jButton2 = new JButton(PolicyTool.getMessage("Cancel"));
            CancelButtonListener cancelButtonListener = new CancelButtonListener(this);
            jButton2.addActionListener(cancelButtonListener);
            this.tw.addNewComponent(this, jButton2, 9, 1, 4, 1, 1, 0.0, 0.0, 3);
            this.getRootPane().setDefaultButton(jButton);
            this.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
        }
        this.pack();
        this.setLocationRelativeTo(this.tw);
        this.setVisible(true);
    }

    void displayPrincipalDialog(boolean bl, boolean bl2) {
        Object object;
        PolicyParser.PrincipalEntry principalEntry = null;
        TaggedList taggedList = (TaggedList)this.getComponent(6);
        int n = taggedList.getSelectedIndex();
        if (bl2) {
            principalEntry = (PolicyParser.PrincipalEntry)taggedList.getObject(n);
        }
        ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Principals"), this.tool, this.tw, true);
        toolDialog.addWindowListener(new ChildWindowListener(toolDialog));
        Point point = this.getLocationOnScreen();
        toolDialog.setLayout(new GridBagLayout());
        toolDialog.setResizable(true);
        JLabel jLabel = bl2 ? new JLabel(PolicyTool.getMessage(".Edit.Principal.")) : new JLabel(PolicyTool.getMessage(".Add.New.Principal."));
        this.tw.addNewComponent(toolDialog, jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(PRIN_TYPE);
        jComboBox.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            object = PRIN_ARRAY.get(i);
            jComboBox.addItem(((Prin)object).CLASS);
        }
        if (bl2) {
            if ("WILDCARD_PRINCIPAL_CLASS".equals(principalEntry.getPrincipalClass())) {
                jComboBox.setSelectedItem(PRIN_TYPE);
            } else {
                Prin prin = ToolDialog.getPrin(principalEntry.getPrincipalClass(), true);
                if (prin != null) {
                    jComboBox.setSelectedItem(prin.CLASS);
                }
            }
        }
        jComboBox.addItemListener(new PrincipalTypeMenuListener(toolDialog));
        this.tw.addNewComponent(toolDialog, jComboBox, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JTextField jTextField = bl2 ? new JTextField(principalEntry.getDisplayClass(), 30) : new JTextField(30);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        this.tw.addNewComponent(toolDialog, jTextField, 2, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_PADDING);
        jLabel = new JLabel(PRIN_NAME);
        jTextField = bl2 ? new JTextField(principalEntry.getDisplayName(), 40) : new JTextField(40);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PRIN_NAME);
        this.tw.addNewComponent(toolDialog, jLabel, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog, jTextField, 4, 1, 2, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new JButton(PolicyTool.getMessage("OK"));
        ((AbstractButton)object).addActionListener(new NewPolicyPrinOKButtonListener(this.tool, this.tw, this, toolDialog, bl2));
        this.tw.addNewComponent(toolDialog, (JComponent)object, 5, 0, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        JButton jButton = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelButtonListener = new CancelButtonListener(toolDialog);
        jButton.addActionListener(cancelButtonListener);
        this.tw.addNewComponent(toolDialog, jButton, 6, 1, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        toolDialog.getRootPane().setDefaultButton((JButton)object);
        toolDialog.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
        toolDialog.pack();
        toolDialog.setLocationRelativeTo(this.tw);
        toolDialog.setVisible(true);
    }

    void displayPermissionDialog(boolean bl, boolean bl2) {
        Object object;
        PolicyParser.PermissionEntry permissionEntry = null;
        TaggedList taggedList = (TaggedList)this.getComponent(8);
        int n = taggedList.getSelectedIndex();
        if (bl2) {
            permissionEntry = (PolicyParser.PermissionEntry)taggedList.getObject(n);
        }
        ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Permissions"), this.tool, this.tw, true);
        toolDialog.addWindowListener(new ChildWindowListener(toolDialog));
        Point point = this.getLocationOnScreen();
        toolDialog.setLayout(new GridBagLayout());
        toolDialog.setResizable(true);
        JLabel jLabel = bl2 ? new JLabel(PolicyTool.getMessage(".Edit.Permission.")) : new JLabel(PolicyTool.getMessage(".Add.New.Permission."));
        this.tw.addNewComponent(toolDialog, jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(PERM);
        jComboBox.getAccessibleContext().setAccessibleName(PERM);
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            object = PERM_ARRAY.get(i);
            jComboBox.addItem(((Perm)object).CLASS);
        }
        this.tw.addNewComponent(toolDialog, jComboBox, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        JTextField jTextField = bl2 ? new JTextField(permissionEntry.permission, 30) : new JTextField(30);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PERM);
        if (bl2 && (object = ToolDialog.getPerm(permissionEntry.permission, true)) != null) {
            jComboBox.setSelectedItem(((Perm)object).CLASS);
        }
        this.tw.addNewComponent(toolDialog, jTextField, 2, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        jComboBox.addItemListener(new PermissionMenuListener(toolDialog));
        jComboBox = new JComboBox();
        jComboBox.addItem(PERM_NAME);
        jComboBox.getAccessibleContext().setAccessibleName(PERM_NAME);
        jTextField = bl2 ? new JTextField(permissionEntry.name, 40) : new JTextField(40);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PERM_NAME);
        if (bl2) {
            this.setPermissionNames(ToolDialog.getPerm(permissionEntry.permission, true), jComboBox, jTextField);
        }
        this.tw.addNewComponent(toolDialog, jComboBox, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        this.tw.addNewComponent(toolDialog, jTextField, 4, 1, 2, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        jComboBox.addItemListener(new PermissionNameMenuListener(toolDialog));
        jComboBox = new JComboBox();
        jComboBox.addItem(PERM_ACTIONS);
        jComboBox.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        jTextField = bl2 ? new JTextField(permissionEntry.action, 40) : new JTextField(40);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        if (bl2) {
            this.setPermissionActions(ToolDialog.getPerm(permissionEntry.permission, true), jComboBox, jTextField);
        }
        this.tw.addNewComponent(toolDialog, jComboBox, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        this.tw.addNewComponent(toolDialog, jTextField, 6, 1, 3, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        jComboBox.addItemListener(new PermissionActionsMenuListener(toolDialog));
        jLabel = new JLabel(PolicyTool.getMessage("Signed.By."));
        this.tw.addNewComponent(toolDialog, jLabel, 7, 0, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        jTextField = bl2 ? new JTextField(permissionEntry.signedBy, 40) : new JTextField(40);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Signed.By."));
        this.tw.addNewComponent(toolDialog, jTextField, 8, 1, 4, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        object = new JButton(PolicyTool.getMessage("OK"));
        ((AbstractButton)object).addActionListener(new NewPolicyPermOKButtonListener(this.tool, this.tw, this, toolDialog, bl2));
        this.tw.addNewComponent(toolDialog, (JComponent)object, 9, 0, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        JButton jButton = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelButtonListener = new CancelButtonListener(toolDialog);
        jButton.addActionListener(cancelButtonListener);
        this.tw.addNewComponent(toolDialog, jButton, 10, 1, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        toolDialog.getRootPane().setDefaultButton((JButton)object);
        toolDialog.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
        toolDialog.pack();
        toolDialog.setLocationRelativeTo(this.tw);
        toolDialog.setVisible(true);
    }

    PolicyParser.PrincipalEntry getPrinFromDialog() throws Exception {
        JTextField jTextField = (JTextField)this.getComponent(2);
        String string = new String(jTextField.getText().trim());
        jTextField = (JTextField)this.getComponent(4);
        String string2 = new String(jTextField.getText().trim());
        if (string.equals("*")) {
            string = "WILDCARD_PRINCIPAL_CLASS";
        }
        if (string2.equals("*")) {
            string2 = "WILDCARD_PRINCIPAL_NAME";
        }
        Object var4_4 = null;
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") && !string2.equals("WILDCARD_PRINCIPAL_NAME")) {
            throw new Exception(PolicyTool.getMessage("Cannot.Specify.Principal.with.a.Wildcard.Class.without.a.Wildcard.Name"));
        }
        if (string2.equals("")) {
            throw new Exception(PolicyTool.getMessage("Cannot.Specify.Principal.without.a.Name"));
        }
        if (string.equals("")) {
            string = "PolicyParser.REPLACE_NAME";
            this.tool.warnings.addElement("Warning: Principal name '" + string2 + "' specified without a Principal class.\n\t'" + string2 + "' will be interpreted as a key store alias.\n\tThe final principal class will be " + X500_PRIN_CLASS + ".\n\tThe final principal name will be determined by the following:\n\n\tIf the key store entry identified by '" + string2 + "'\n\tis a key entry, then the principal name will be\n\tthe subject distinguished name from the first\n\tcertificate in the entry's certificate chain.\n\n\tIf the key store entry identified by '" + string2 + "'\n\tis a trusted certificate entry, then the\n\tprincipal name will be the subject distinguished\n\tname from the trusted public key certificate.");
            this.tw.displayStatusDialog(this, "'" + string2 + "' will be interpreted as a key store alias.  View Warning Log for details.");
        }
        return new PolicyParser.PrincipalEntry(string, string2);
    }

    PolicyParser.PermissionEntry getPermFromDialog() {
        char c;
        JTextField jTextField = (JTextField)this.getComponent(2);
        String string = new String(jTextField.getText().trim());
        jTextField = (JTextField)this.getComponent(4);
        String string2 = null;
        if (!jTextField.getText().trim().equals("")) {
            string2 = new String(jTextField.getText().trim());
        }
        if (string.equals("") || !string.equals(ALL_PERM_CLASS) && string2 == null) {
            throw new InvalidParameterException(PolicyTool.getMessage("Permission.and.Target.Name.must.have.a.value"));
        }
        if (string.equals(FILE_PERM_CLASS) && string2.lastIndexOf("\\\\") > 0 && (c = this.tw.displayYesNoDialog(this, PolicyTool.getMessage("Warning"), PolicyTool.getMessage("Warning.File.name.may.include.escaped.backslash.characters.It.is.not.necessary.to.escape.backslash.characters.the.tool.escapes"), PolicyTool.getMessage("Retain"), PolicyTool.getMessage("Edit"))) != 'Y') {
            throw new NoDisplayException();
        }
        jTextField = (JTextField)this.getComponent(6);
        String string3 = null;
        if (!jTextField.getText().trim().equals("")) {
            string3 = new String(jTextField.getText().trim());
        }
        jTextField = (JTextField)this.getComponent(8);
        String string4 = null;
        if (!jTextField.getText().trim().equals("")) {
            string4 = new String(jTextField.getText().trim());
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(string, string2, string3);
        permissionEntry.signedBy = string4;
        if (string4 != null) {
            String[] stringArray = this.tool.parseSigners(permissionEntry.signedBy);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    PublicKey publicKey = this.tool.getPublicKeyAlias(stringArray[i]);
                    if (publicKey != null) continue;
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.getMessage("Warning.A.public.key.for.alias.signers.i.does.not.exist.Make.sure.a.KeyStore.is.properly.configured."));
                    Object[] objectArray = new Object[]{stringArray[i]};
                    this.tool.warnings.addElement(messageFormat.format(objectArray));
                    this.tw.displayStatusDialog(this, messageFormat.format(objectArray));
                    continue;
                }
                catch (Exception exception) {
                    this.tw.displayErrorDialog((Window)this, exception);
                }
            }
        }
        return permissionEntry;
    }

    void displayConfirmRemovePolicyEntry() {
        Object object;
        Object object2;
        JList jList = (JList)this.tw.getComponent(3);
        int n = jList.getSelectedIndex();
        PolicyEntry[] policyEntryArray = this.tool.getEntry();
        Point point = this.tw.getLocationOnScreen();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(PolicyTool.getMessage("Remove.this.Policy.Entry."));
        this.tw.addNewComponent(this, jLabel, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jLabel = new JLabel(policyEntryArray[n].codebaseToString());
        this.tw.addNewComponent(this, jLabel, 1, 0, 1, 2, 1, 0.0, 0.0, 1);
        jLabel = new JLabel(policyEntryArray[n].principalsToString().trim());
        this.tw.addNewComponent(this, jLabel, 2, 0, 2, 2, 1, 0.0, 0.0, 1);
        Vector<PolicyParser.PermissionEntry> vector = policyEntryArray[n].getGrantEntry().permissionEntries;
        for (int i = 0; i < vector.size(); ++i) {
            object2 = vector.elementAt(i);
            object = ToolDialog.PermissionEntryToUserFriendlyString((PolicyParser.PermissionEntry)object2);
            jLabel = new JLabel("    " + (String)object);
            if (i == vector.size() - 1) {
                this.tw.addNewComponent(this, jLabel, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
                continue;
            }
            this.tw.addNewComponent(this, jLabel, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        object2 = new JButton(PolicyTool.getMessage("OK"));
        ((AbstractButton)object2).addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(jPanel, (JComponent)object2, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        object = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelButtonListener = new CancelButtonListener(this);
        ((AbstractButton)object).addActionListener(cancelButtonListener);
        this.tw.addNewComponent(jPanel, (JComponent)object, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, jPanel, 3 + vector.size(), 0, 3 + vector.size(), 2, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        this.getRootPane().setDefaultButton((JButton)object2);
        this.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
        this.pack();
        this.setLocationRelativeTo(this.tw);
        this.setVisible(true);
    }

    void displaySaveAsDialog(int n) {
        FileDialog fileDialog = new FileDialog((Frame)this.tw, PolicyTool.getMessage("Save.As"), 1);
        fileDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().setVisible(false);
            }
        });
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
            return;
        }
        File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
        String string = file.getPath();
        fileDialog.dispose();
        try {
            this.tool.savePolicy(string);
            MessageFormat messageFormat = new MessageFormat(PolicyTool.getMessage("Policy.successfully.written.to.filename"));
            Object[] objectArray = new Object[]{string};
            this.tw.displayStatusDialog(null, messageFormat.format(objectArray));
            JTextField jTextField = (JTextField)this.tw.getComponent(1);
            jTextField.setText(string);
            this.tw.setVisible(true);
            this.userSaveContinue(this.tool, this.tw, this, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string == null || string.equals("")) {
                this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.getMessage("null.filename")));
            } else {
                this.tw.displayErrorDialog(null, fileNotFoundException);
            }
        }
        catch (Exception exception) {
            this.tw.displayErrorDialog(null, exception);
        }
    }

    void displayUserSave(int n) {
        if (this.tool.modified) {
            Point point = this.tw.getLocationOnScreen();
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(PolicyTool.getMessage("Save.changes."));
            this.tw.addNewComponent(this, jLabel, 0, 0, 0, 3, 1, 0.0, 0.0, 1, ToolWindow.L_TOP_BOTTOM_PADDING);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            JButton jButton = new JButton();
            ToolWindow.configureButton(jButton, "Yes");
            jButton.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            JButton jButton2 = new JButton();
            ToolWindow.configureButton(jButton2, "No");
            jButton2.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(jPanel, jButton2, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            JButton jButton3 = new JButton();
            ToolWindow.configureButton(jButton3, "Cancel");
            CancelButtonListener cancelButtonListener = new CancelButtonListener(this);
            jButton3.addActionListener(cancelButtonListener);
            this.tw.addNewComponent(jPanel, jButton3, 2, 2, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            this.tw.addNewComponent(this, jPanel, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            this.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
            this.pack();
            this.setLocationRelativeTo(this.tw);
            this.setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, this, n);
        }
    }

    void userSaveContinue(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, int n) {
        switch (n) {
            case 1: {
                toolWindow.setVisible(false);
                toolWindow.dispose();
                System.exit(0);
            }
            case 2: {
                try {
                    policyTool.openPolicy(null);
                }
                catch (Exception exception) {
                    policyTool.modified = false;
                    toolWindow.displayErrorDialog(null, exception);
                }
                JList jList = new JList(new DefaultListModel());
                jList.setVisibleRowCount(15);
                jList.setSelectionMode(0);
                jList.addMouseListener(new PolicyListListener(policyTool, toolWindow));
                toolWindow.replacePolicyList(jList);
                JTextField jTextField = (JTextField)toolWindow.getComponent(1);
                jTextField.setText("");
                toolWindow.setVisible(true);
                break;
            }
            case 3: {
                FileDialog fileDialog = new FileDialog((Frame)toolWindow, PolicyTool.getMessage("Open"), 0);
                fileDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().setVisible(false);
                    }
                });
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
                    return;
                }
                String string = new File(fileDialog.getDirectory(), fileDialog.getFile()).getPath();
                try {
                    policyTool.openPolicy(string);
                    DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                    JList jList = new JList(defaultListModel);
                    jList.setVisibleRowCount(15);
                    jList.setSelectionMode(0);
                    jList.addMouseListener(new PolicyListListener(policyTool, toolWindow));
                    PolicyEntry[] policyEntryArray = policyTool.getEntry();
                    if (policyEntryArray != null) {
                        for (int i = 0; i < policyEntryArray.length; ++i) {
                            defaultListModel.addElement(policyEntryArray[i].headerToString());
                        }
                    }
                    toolWindow.replacePolicyList(jList);
                    policyTool.modified = false;
                    JTextField jTextField = (JTextField)toolWindow.getComponent(1);
                    jTextField.setText(string);
                    toolWindow.setVisible(true);
                    if (!policyTool.newWarning) break;
                    toolWindow.displayStatusDialog(null, PolicyTool.getMessage("Errors.have.occurred.while.opening.the.policy.configuration.View.the.Warning.Log.for.more.information."));
                    break;
                }
                catch (Exception exception) {
                    JList jList = new JList(new DefaultListModel());
                    jList.setVisibleRowCount(15);
                    jList.setSelectionMode(0);
                    jList.addMouseListener(new PolicyListListener(policyTool, toolWindow));
                    toolWindow.replacePolicyList(jList);
                    policyTool.setPolicyFileName(null);
                    policyTool.modified = false;
                    JTextField jTextField = (JTextField)toolWindow.getComponent(1);
                    jTextField.setText("");
                    toolWindow.setVisible(true);
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.getMessage("Could.not.open.policy.file.policyFile.e.toString."));
                    Object[] objectArray = new Object[]{string, exception.toString()};
                    toolWindow.displayErrorDialog(null, messageFormat.format(objectArray));
                }
            }
        }
    }

    void setPermissionNames(Perm perm, JComboBox jComboBox, JTextField jTextField) {
        jComboBox.removeAllItems();
        jComboBox.addItem(PERM_NAME);
        if (perm == null) {
            jTextField.setEditable(true);
        } else if (perm.TARGETS == null) {
            jTextField.setEditable(false);
        } else {
            jTextField.setEditable(true);
            for (int i = 0; i < perm.TARGETS.length; ++i) {
                jComboBox.addItem(perm.TARGETS[i]);
            }
        }
    }

    void setPermissionActions(Perm perm, JComboBox jComboBox, JTextField jTextField) {
        jComboBox.removeAllItems();
        jComboBox.addItem(PERM_ACTIONS);
        if (perm == null) {
            jTextField.setEditable(true);
        } else if (perm.ACTIONS == null) {
            jTextField.setEditable(false);
        } else {
            jTextField.setEditable(true);
            for (int i = 0; i < perm.ACTIONS.length; ++i) {
                jComboBox.addItem(perm.ACTIONS[i]);
            }
        }
    }

    static String PermissionEntryToUserFriendlyString(PolicyParser.PermissionEntry permissionEntry) {
        String string = permissionEntry.permission;
        if (permissionEntry.name != null) {
            string = string + " " + permissionEntry.name;
        }
        if (permissionEntry.action != null) {
            string = string + ", \"" + permissionEntry.action + "\"";
        }
        if (permissionEntry.signedBy != null) {
            string = string + ", signedBy " + permissionEntry.signedBy;
        }
        return string;
    }

    static String PrincipalEntryToUserFriendlyString(PolicyParser.PrincipalEntry principalEntry) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        principalEntry.write(printWriter);
        return stringWriter.toString();
    }

    static {
        PERM_ARRAY.add(new AllPerm());
        PERM_ARRAY.add(new AudioPerm());
        PERM_ARRAY.add(new AuthPerm());
        PERM_ARRAY.add(new AWTPerm());
        PERM_ARRAY.add(new DelegationPerm());
        PERM_ARRAY.add(new FilePerm());
        PERM_ARRAY.add(new URLPerm());
        PERM_ARRAY.add(new InqSecContextPerm());
        PERM_ARRAY.add(new LogPerm());
        PERM_ARRAY.add(new MgmtPerm());
        PERM_ARRAY.add(new MBeanPerm());
        PERM_ARRAY.add(new MBeanSvrPerm());
        PERM_ARRAY.add(new MBeanTrustPerm());
        PERM_ARRAY.add(new NetPerm());
        PERM_ARRAY.add(new PrivCredPerm());
        PERM_ARRAY.add(new PropPerm());
        PERM_ARRAY.add(new ReflectPerm());
        PERM_ARRAY.add(new RuntimePerm());
        PERM_ARRAY.add(new SecurityPerm());
        PERM_ARRAY.add(new SerialPerm());
        PERM_ARRAY.add(new ServicePerm());
        PERM_ARRAY.add(new SocketPerm());
        PERM_ARRAY.add(new SQLPerm());
        PERM_ARRAY.add(new SSLPerm());
        PERM_ARRAY.add(new SubjDelegPerm());
        PRIN_ARRAY = new ArrayList();
        PRIN_ARRAY.add(new KrbPrin());
        PRIN_ARRAY.add(new X500Prin());
    }
}

