/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility;

import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class StructureTree2SAXEventAdapter
implements StructureTreeEventHandler {
    private final ContentHandler contentHandler;

    private StructureTree2SAXEventAdapter(ContentHandler currentContentHandler) {
        this.contentHandler = currentContentHandler;
    }

    public static StructureTreeEventHandler newInstance(ContentHandler contentHandler) {
        return new StructureTree2SAXEventAdapter(contentHandler);
    }

    public void startPageSequence(Locale locale, String role) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            if (role != null) {
                attributes.addAttribute("", "type", "type", "CDATA", role);
            }
            this.contentHandler.startPrefixMapping("foi", "http://xmlgraphics.apache.org/fop/internal");
            this.contentHandler.startPrefixMapping("fox", "http://xmlgraphics.apache.org/fop/extensions");
            this.contentHandler.startElement("http://xmlgraphics.apache.org/fop/intermediate", "structure-tree", "structure-tree", attributes);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void endPageSequence() {
        try {
            this.contentHandler.endElement("http://xmlgraphics.apache.org/fop/intermediate", "structure-tree", "structure-tree");
            this.contentHandler.endPrefixMapping("fox");
            this.contentHandler.endPrefixMapping("foi");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public StructureTreeElement startNode(String name, Attributes attributes, StructureTreeElement parent) {
        try {
            if (name.equals("#PCDATA")) {
                name = "marked-content";
                this.contentHandler.startElement("http://xmlgraphics.apache.org/fop/intermediate", name, name, attributes);
            } else {
                this.contentHandler.startElement("http://www.w3.org/1999/XSL/Format", name, "fo:" + name, attributes);
            }
            return null;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void endNode(String name) {
        try {
            this.contentHandler.endElement("http://www.w3.org/1999/XSL/Format", name, "fo:" + name);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public StructureTreeElement startImageNode(String name, Attributes attributes, StructureTreeElement parent) {
        return this.startNode(name, attributes, null);
    }

    public StructureTreeElement startReferencedNode(String name, Attributes attributes, StructureTreeElement parent) {
        return this.startNode(name, attributes, null);
    }
}

