/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;

public final class SuspendedEvent {
    private static final boolean TRACE = Boolean.getBoolean("truffle.debug.trace");
    private static final String TRACE_PREFIX = "Suspnd: ";
    private static final PrintStream OUT = System.out;
    private final Debugger debugger;
    private final Node haltedNode;
    private final Debugger.HaltPosition haltedPosition;
    private final MaterializedFrame haltedFrame;
    private final List<FrameInstance> stack;
    private final List<String> warnings;
    private volatile boolean kill;

    private static void trace(String format, Object ... args) {
        if (TRACE) {
            OUT.println(TRACE_PREFIX + String.format(format, args));
        }
    }

    SuspendedEvent(Debugger debugger, Node haltedNode, Debugger.HaltPosition haltedPosition, MaterializedFrame haltedFrame, List<FrameInstance> stack, List<String> warnings) {
        this.debugger = debugger;
        this.haltedNode = haltedNode;
        this.haltedPosition = haltedPosition;
        this.haltedFrame = haltedFrame;
        this.stack = stack;
        this.warnings = warnings;
        if (TRACE) {
            SuspendedEvent.trace("Execution suspended at Node=" + haltedNode, new Object[0]);
        }
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public Node getNode() {
        return this.haltedNode;
    }

    public boolean isHaltedBefore() {
        return this.haltedPosition == Debugger.HaltPosition.BEFORE;
    }

    public MaterializedFrame getFrame() {
        return this.haltedFrame;
    }

    public List<String> getRecentWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    @CompilerDirectives.TruffleBoundary
    public List<FrameInstance> getStack() {
        return this.stack;
    }

    public void prepareContinue() {
        this.debugger.prepareContinue(-1);
    }

    public void prepareStepInto(int stepCount) {
        this.debugger.prepareStepInto(stepCount);
    }

    public void prepareStepOut() {
        this.debugger.prepareStepOut();
    }

    public void prepareStepOver(int stepCount) {
        this.debugger.prepareStepOver(stepCount);
    }

    public Object eval(String code, FrameInstance frameInstance) throws IOException {
        if (!this.stack.contains(frameInstance)) {
            throw new IllegalArgumentException();
        }
        return this.debugger.evalInContext(this, code, frameInstance);
    }

    public String toString(Object value, FrameInstance frameInstance) {
        if (!this.stack.contains(frameInstance)) {
            throw new IllegalArgumentException();
        }
        RootNode rootNode = null;
        if (frameInstance == this.stack.get(0)) {
            rootNode = this.haltedNode.getRootNode();
        } else if (frameInstance.getCallTarget() instanceof RootCallTarget) {
            rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
        }
        if (rootNode == null) {
            return value.toString();
        }
        return Debugger.ACCESSOR.toStringInContext(rootNode, value);
    }

    public void prepareKill() {
        this.kill = true;
    }

    boolean isKillPrepared() {
        return this.kill;
    }
}

