/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayAppendManyNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ArrayAppendManyNode.class)
public final class ArrayAppendManyNodeGen
extends ArrayAppendManyNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode other_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayAppendManyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
        super(context, sourceSection);
        this.array_ = array;
        this.other_ = other;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeAppendMany(DynamicObject arrayValue, DynamicObject otherValue) {
        return this.specialization_.executeDynamicObject1(arrayValue, otherValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayAppendManyNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
        return new ArrayAppendManyNodeGen(context, sourceSection, array, other);
    }

    @GeneratedBy(methodName="appendManyGeneralize(DynamicObject, DynamicObject, ArrayStrategy, ArrayStrategy, ArrayStrategy, ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final ArrayStrategy otherStrategy;
        private final ArrayStrategy generalized;
        private final ConditionProfile extendProfile;

        AppendManyGeneralizeNode_(ArrayAppendManyNodeGen root, ArrayStrategy strategy, ArrayStrategy otherStrategy, ArrayStrategy generalized, ConditionProfile extendProfile) {
            super(root, 5);
            this.strategy = strategy;
            this.otherStrategy = otherStrategy;
            this.generalized = generalized;
            this.extendProfile = extendProfile;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (this.strategy.matches(arrayValue_) && this.otherStrategy.matches(otherValue_)) {
                    assert (!this.strategy.canStore(this.otherStrategy.type()));
                    return true;
                }
            }
            return false;
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
            if (this.strategy.matches(arrayValue) && this.otherStrategy.matches(otherValue)) {
                assert (!this.strategy.canStore(this.otherStrategy.type()));
                return this.root.appendManyGeneralize(arrayValue, otherValue, this.strategy, this.otherStrategy, this.generalized, this.extendProfile);
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (this.strategy.matches(arrayValue_) && this.otherStrategy.matches(otherValue_)) {
                    assert (!this.strategy.canStore(this.otherStrategy.type()));
                    return this.root.appendManyGeneralize(arrayValue_, otherValue_, this.strategy, this.otherStrategy, this.generalized, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, ArrayStrategy strategy, ArrayStrategy otherStrategy, ArrayStrategy generalized, ConditionProfile extendProfile) {
            return new AppendManyGeneralizeNode_(root, strategy, otherStrategy, generalized, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(DynamicObject, DynamicObject, ArrayStrategy, ArrayStrategy, ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManySameTypeNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final ArrayStrategy otherStrategy;
        private final ConditionProfile extendProfile;

        AppendManySameTypeNode_(ArrayAppendManyNodeGen root, ArrayStrategy strategy, ArrayStrategy otherStrategy, ConditionProfile extendProfile) {
            super(root, 4);
            this.strategy = strategy;
            this.otherStrategy = otherStrategy;
            this.extendProfile = extendProfile;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (this.strategy.matches(arrayValue_) && this.otherStrategy.matches(otherValue_)) {
                    assert (this.strategy.canStore(this.otherStrategy.type()));
                    return true;
                }
            }
            return false;
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
            if (this.strategy.matches(arrayValue) && this.otherStrategy.matches(otherValue)) {
                assert (this.strategy.canStore(this.otherStrategy.type()));
                return this.root.appendManySameType(arrayValue, otherValue, this.strategy, this.otherStrategy, this.extendProfile);
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (this.strategy.matches(arrayValue_) && this.otherStrategy.matches(otherValue_)) {
                    assert (this.strategy.canStore(this.otherStrategy.type()));
                    return this.root.appendManySameType(arrayValue_, otherValue_, this.strategy, this.otherStrategy, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, ArrayStrategy strategy, ArrayStrategy otherStrategy, ConditionProfile extendProfile) {
            return new AppendManySameTypeNode_(root, strategy, otherStrategy, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyOtherEmpty(DynamicObject, DynamicObject)", value=ArrayAppendManyNode.class)
    private static final class AppendManyOtherEmptyNode_
    extends BaseNode_ {
        AppendManyOtherEmptyNode_(ArrayAppendManyNodeGen root) {
            super(root, 3);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
            if (ArrayGuards.isEmptyArray(otherValue)) {
                return this.root.appendManyOtherEmpty(arrayValue, otherValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (ArrayGuards.isEmptyArray(otherValue_)) {
                    return this.root.appendManyOtherEmpty(arrayValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root) {
            return new AppendManyOtherEmptyNode_(root);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayAppendManyNode.class)
    private static final class AppendManyEmptyNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;

        AppendManyEmptyNode_(ArrayAppendManyNodeGen root, ArrayStrategy strategy) {
            super(root, 2);
            this.strategy = strategy;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_) && this.strategy.matches(otherValue_)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
            if (ArrayGuards.isEmptyArray(arrayValue) && this.strategy.matches(otherValue)) {
                return this.root.appendManyEmpty(arrayValue, otherValue, this.strategy);
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_) && this.strategy.matches(otherValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherValue_, this.strategy);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, ArrayStrategy strategy) {
            return new AppendManyEmptyNode_(root, strategy);
        }
    }

    @GeneratedBy(methodName="appendManyNullNull(DynamicObject, DynamicObject)", value=ArrayAppendManyNode.class)
    private static final class AppendManyNullNullNode_
    extends BaseNode_ {
        AppendManyNullNullNode_(ArrayAppendManyNodeGen root) {
            super(root, 1);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
            if (ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isNullArray(otherValue)) {
                return this.root.appendManyNullNull(arrayValue, otherValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isNullArray(otherValue_)) {
                    return this.root.appendManyNullNull(arrayValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root) {
            return new AppendManyNullNullNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAppendManyNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayAppendManyNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object otherValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, otherValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            return this.getNext().executeDynamicObject_(arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAppendManyNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayAppendManyNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
            return (DynamicObject)this.uninitialized((Frame)null, arrayValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAppendManyNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayAppendManyNodeGen root;

        BaseNode_(ArrayAppendManyNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayAppendManyNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.other_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object otherValue) {
            return this.executeDynamicObject_(arrayValue, otherValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2);

        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
            return this.executeDynamicObject_(arrayValue, otherValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.executeDynamicObject_(arrayValue_, otherValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                ConditionProfile extendProfile5;
                ArrayStrategy generalized5;
                BaseNode_ s;
                ConditionProfile extendProfile4;
                BaseNode_ s2;
                BaseNode_ s3;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                DynamicObject otherValue_ = (DynamicObject)otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isNullArray(otherValue_)) {
                    return AppendManyNullNullNode_.create(this.root);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(otherValue_);
                if (ArrayGuards.isEmptyArray(arrayValue_) && strategy2.matches(otherValue_) && this.countSame(s3 = AppendManyEmptyNode_.create(this.root, strategy2)) < 25) {
                    return s3;
                }
                if (ArrayGuards.isEmptyArray(otherValue_)) {
                    return AppendManyOtherEmptyNode_.create(this.root);
                }
                ArrayStrategy strategy4 = ArrayStrategy.of(arrayValue_);
                ArrayStrategy otherStrategy4 = ArrayStrategy.of(otherValue_);
                if (strategy4.matches(arrayValue_) && otherStrategy4.matches(otherValue_) && strategy4.canStore(otherStrategy4.type()) && this.countSame(s2 = AppendManySameTypeNode_.create(this.root, strategy4, otherStrategy4, extendProfile4 = ConditionProfile.createBinaryProfile())) < 25) {
                    return s2;
                }
                ArrayStrategy strategy5 = ArrayStrategy.of(arrayValue_);
                ArrayStrategy otherStrategy5 = ArrayStrategy.of(otherValue_);
                if (strategy5.matches(arrayValue_) && otherStrategy5.matches(otherValue_) && !strategy5.canStore(otherStrategy5.type()) && this.countSame(s = AppendManyGeneralizeNode_.create(this.root, strategy5, otherStrategy5, generalized5 = strategy5.generalize(otherStrategy5), extendProfile5 = ConditionProfile.createBinaryProfile())) < 25) {
                    return s;
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

