/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleManager;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ModuleSystem;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class RecognizeInstanceObjects
extends NamedServicesProvider {
    private static final Logger LOG = Logger.getLogger(RecognizeInstanceObjects.class.getName());

    public <T> T lookupObject(String string, Class<T> clazz) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject != null) {
            try {
                InstanceCookie instanceCookie = (InstanceCookie)DataObject.find((FileObject)fileObject).getLookup().lookup(InstanceCookie.class);
                Object object = instanceCookie != null ? instanceCookie.instanceCreate() : null;
                return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Cannot create instance for " + string, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.INFO, "Cannot create instance for " + string, classNotFoundException);
            }
        }
        return null;
    }

    public Lookup create(String string) {
        return new OverObjects(string);
    }

    protected Lookup lookupFor(Object object) {
        if (object instanceof FileObject) {
            try {
                return DataObject.find((FileObject)((FileObject)object)).getLookup();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.INFO, "Can't find DataObject for " + object, dataObjectNotFoundException);
            }
        }
        return null;
    }

    private static final class OverObjects
    extends ProxyLookup
    implements PropertyChangeListener,
    FileChangeListener {
        private final String path;

        public OverObjects(String string) {
            block6: {
                ModuleSystem moduleSystem;
                super(OverObjects.delegates(null, string));
                this.path = string;
                try {
                    moduleSystem = Main.getModuleSystem((boolean)false);
                    if (moduleSystem != null) {
                        ModuleManager moduleManager = moduleSystem.getManager();
                        moduleManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleManager));
                    } else {
                        LOG.log(Level.WARNING, "Not listening on module system");
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "Can't listen on module system", throwable);
                }
                try {
                    moduleSystem = FileUtil.getConfigRoot().getFileSystem();
                    moduleSystem.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)moduleSystem));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }

        private static Lookup[] delegates(Lookup lookup, String string) {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            LOG.log(Level.FINEST, "lkp loader: {0}", classLoader);
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
                LOG.log(Level.FINEST, "ccl: {0}", classLoader);
            }
            if (classLoader == null) {
                classLoader = RecognizeInstanceObjects.class.getClassLoader();
            }
            LOG.log(Level.FINER, "metaInfServices for {0}", classLoader);
            Lookup lookup2 = Lookups.metaInfServices((ClassLoader)classLoader, (String)("META-INF/namedservices/" + string));
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (fileObject == null) {
                return new Lookup[]{lookup2};
            }
            String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            if (lookup == null) {
                lookup = new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fileObject), string2).getLookup();
            }
            return new Lookup[]{lookup, lookup2};
        }

        Lookup extractFolderLkp() {
            Lookup[] lookupArray = this.getLookups();
            return lookupArray.length == 2 ? lookupArray[0] : null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setLookups(OverObjects.delegates(this.extractFolderLkp(), this.path));
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.ch((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.ch((FileEvent)fileAttributeEvent);
        }

        private void ch(FileEvent fileEvent) {
            if ((fileEvent.getFile().getPath() + "/").startsWith(this.path)) {
                this.setLookups(OverObjects.delegates(this.extractFolderLkp(), this.path));
            }
        }
    }
}

