/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.exceptions.JadxException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckRegions
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(CheckRegions.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode() || mth.getBasicBlocks().isEmpty() || mth.contains(AType.JADX_ERROR)) {
            return;
        }
        final HashSet blocksInRegions = new HashSet();
        DepthRegionTraversal.traverse(mth, new AbstractRegionVisitor(){

            @Override
            public void processBlock(MethodNode mth, IBlock container) {
                if (!(container instanceof BlockNode)) {
                    return;
                }
                BlockNode block = (BlockNode)container;
                if (blocksInRegions.add(block)) {
                    return;
                }
                if (!(block.contains(AFlag.RETURN) || block.contains(AFlag.SKIP) || block.contains(AFlag.SYNTHETIC) || block.getInstructions().isEmpty())) {
                    LOG.debug(" Duplicated block: {} in {}", (Object)block, (Object)mth);
                }
            }
        });
        if (mth.getBasicBlocks().size() != blocksInRegions.size()) {
            for (BlockNode block : mth.getBasicBlocks()) {
                if (blocksInRegions.contains(block) || block.getInstructions().isEmpty() || block.contains(AFlag.SKIP)) continue;
                mth.add(AFlag.INCONSISTENT_CODE);
                LOG.debug(" Missing block: {} in {}", (Object)block, (Object)mth);
            }
        }
        DepthRegionTraversal.traverse(mth, new AbstractRegionVisitor(){

            @Override
            public void enterRegion(MethodNode mth, IRegion region) {
                BlockNode loopHeader;
                if (region instanceof LoopRegion && (loopHeader = ((LoopRegion)region).getHeader()) != null && loopHeader.getInstructions().size() != 1) {
                    ErrorsCounter.methodError(mth, "Incorrect condition in loop: " + loopHeader);
                }
            }
        });
    }
}

