/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Content;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

final class BytesSourceImpl
extends Content
implements Content.CreateURI {
    private final String name;
    private final byte[] bytes;
    private final int byteIndex;
    private final int length;
    private final CharsetDecoder decoder;

    BytesSourceImpl(String name, byte[] bytes, int byteIndex, int length, Charset decoder) {
        this.name = name;
        this.bytes = bytes;
        this.byteIndex = byteIndex;
        this.length = length;
        this.decoder = decoder.newDecoder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.name;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    URI getURI() {
        return this.createURIOnce(this);
    }

    @Override
    public URI createURI() {
        return this.getNamedURI(this.name, this.bytes, this.byteIndex, this.length);
    }

    @Override
    public Reader getReader() {
        return null;
    }

    @Override
    public String getCode() {
        CharBuffer chb;
        ByteBuffer bb = ByteBuffer.wrap(this.bytes, this.byteIndex, this.length);
        try {
            chb = this.decoder.decode(bb);
        }
        catch (CharacterCodingException ex) {
            return "";
        }
        this.code = chb.toString();
        return this.code;
    }

    @Override
    String findMimeType() throws IOException {
        return null;
    }

    @Override
    Object getHashKey() {
        int hash = this.bytes.length;
        if (this.bytes.length > 0) {
            int oneFourth = this.bytes.length / 4;
            int oneHalf = this.bytes.length / 2;
            hash ^= this.bytes[0];
            hash ^= this.bytes[oneFourth] << 8;
            hash ^= this.bytes[oneHalf] << 16;
            hash ^= this.bytes[oneHalf + oneFourth] << 24;
        }
        return hash;
    }
}

