/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerAsserts;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.truffle.RubyContext;

public abstract class ArrayUtils {
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static int[] extractRange(int[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        int[] result = new int[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static long[] extractRange(long[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        long[] result = new long[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static double[] extractRange(double[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        double[] result = new double[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static Object[] extractRange(Object[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        Object[] result = new Object[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    private static boolean assertExtractRangeArgs(Object source, int start, int end) {
        assert (source != null);
        assert (start >= 0);
        assert (start <= Array.getLength(source));
        assert (end >= start);
        assert (end <= Array.getLength(source));
        return true;
    }

    public static boolean contains(int[] array, int value) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] array, double value) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value) continue;
            return true;
        }
        return false;
    }

    public static Object[] box(int[] unboxed) {
        return ArrayUtils.boxExtra(unboxed, 0);
    }

    public static Object[] box(long[] unboxed) {
        return ArrayUtils.boxExtra(unboxed, 0);
    }

    public static Object[] box(double[] unboxed) {
        return ArrayUtils.boxExtra(unboxed, 0);
    }

    public static Object[] box(Object array) {
        return ArrayUtils.boxExtra(array, 0);
    }

    public static Object[] box(int[] unboxed, int newLength) {
        Object[] boxed = new Object[newLength];
        int boxCount = Math.min(unboxed.length, newLength);
        for (int n = 0; n < boxCount; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(long[] unboxed, int newLength) {
        Object[] boxed = new Object[newLength];
        int boxCount = Math.min(unboxed.length, newLength);
        for (int n = 0; n < boxCount; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(double[] unboxed, int newLength) {
        Object[] boxed = new Object[newLength];
        int boxCount = Math.min(unboxed.length, newLength);
        for (int n = 0; n < boxCount; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxExtra(int[] unboxed, int extra) {
        assert (extra >= 0) : "extra is not negative";
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxExtra(long[] unboxed, int extra) {
        assert (extra >= 0) : "extra is not negative";
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxExtra(double[] unboxed, int extra) {
        assert (extra >= 0) : "extra is not negative";
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxExtra(Object array, int extra) {
        assert (extra >= 0) : "extra is not negative";
        CompilerAsserts.neverPartOfCompilation();
        if (array == null) {
            return new Object[extra];
        }
        if (array instanceof int[]) {
            return ArrayUtils.boxExtra((int[])array, extra);
        }
        if (array instanceof long[]) {
            return ArrayUtils.boxExtra((long[])array, extra);
        }
        if (array instanceof double[]) {
            return ArrayUtils.boxExtra((double[])array, extra);
        }
        if (array.getClass() == Object[].class) {
            Object[] objectArray = (Object[])array;
            return ArrayUtils.grow(objectArray, objectArray.length + extra);
        }
        throw new UnsupportedOperationException();
    }

    public static Object[] boxUntil(int[] unboxed, int length) {
        Object[] boxed = new Object[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(long[] unboxed, int length) {
        Object[] boxed = new Object[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(double[] unboxed, int length) {
        Object[] boxed = new Object[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(Object array, int length) {
        CompilerAsserts.neverPartOfCompilation();
        if (array == null) {
            return EMPTY_ARRAY;
        }
        if (array instanceof int[]) {
            return ArrayUtils.boxUntil((int[])array, length);
        }
        if (array instanceof long[]) {
            return ArrayUtils.boxUntil((long[])array, length);
        }
        if (array instanceof double[]) {
            return ArrayUtils.boxUntil((double[])array, length);
        }
        if (array.getClass() == Object[].class) {
            Object[] objectArray = (Object[])array;
            return Arrays.copyOf(objectArray, length);
        }
        throw new UnsupportedOperationException();
    }

    public static int[] unboxInteger(Object[] unboxed, int length) {
        CompilerAsserts.neverPartOfCompilation();
        int[] boxed = new int[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = (Integer)unboxed[n];
        }
        return boxed;
    }

    public static long[] unboxLong(Object[] unboxed, int length) {
        CompilerAsserts.neverPartOfCompilation();
        long[] boxed = new long[length];
        for (int n = 0; n < length; ++n) {
            Object value = unboxed[n];
            if (value instanceof Integer) {
                boxed[n] = ((Integer)unboxed[n]).intValue();
                continue;
            }
            if (!(value instanceof Long)) continue;
            boxed[n] = (Long)unboxed[n];
        }
        return boxed;
    }

    public static double[] unboxDouble(Object[] unboxed, int length) {
        CompilerAsserts.neverPartOfCompilation();
        double[] boxed = new double[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = (Double)unboxed[n];
        }
        return boxed;
    }

    public static void copy(Object source, Object[] destination, int destinationStart, int length) {
        if (length == 0) {
            return;
        }
        if (source instanceof int[]) {
            int[] unboxedSource = (int[])source;
            for (int n = 0; n < length; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source instanceof long[]) {
            long[] unboxedSource = (long[])source;
            for (int n = 0; n < length; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source instanceof double[]) {
            double[] unboxedSource = (double[])source;
            for (int n = 0; n < length; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source.getClass() == Object[].class) {
            ArrayUtils.arraycopy((Object[])source, 0, destination, destinationStart, length);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static long[] longCopyOf(int[] ints) {
        return ArrayUtils.longCopyOf(ints, ints.length);
    }

    public static long[] longCopyOf(int[] ints, int newLength) {
        assert (newLength >= ints.length);
        long[] longs = new long[newLength];
        for (int n = 0; n < ints.length; ++n) {
            longs[n] = ints[n];
        }
        return longs;
    }

    public static int capacity(RubyContext context, int current, int needed) {
        if (needed == 0) {
            return 0;
        }
        assert (current < needed);
        if (needed < context.getOptions().ARRAY_UNINITIALIZED_SIZE) {
            return context.getOptions().ARRAY_UNINITIALIZED_SIZE;
        }
        int newCapacity = current << 1;
        if (newCapacity >= needed) {
            return newCapacity;
        }
        return needed;
    }

    public static int capacityForOneMore(RubyContext context, int current) {
        if (current < context.getOptions().ARRAY_UNINITIALIZED_SIZE) {
            return context.getOptions().ARRAY_UNINITIALIZED_SIZE;
        }
        return current << 1;
    }

    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static Object[] copyOf(Object[] array, int newLength) {
        Object[] copy = new Object[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static Object[] grow(Object[] array, int newLength) {
        assert (newLength >= array.length);
        Object[] copy = new Object[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static Object[] copy(Object[] array) {
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static Object[] unshift(Object[] array, Object element) {
        Object[] newArray = new Object[1 + array.length];
        newArray[0] = element;
        ArrayUtils.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }
}

