/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.Base64;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIRealm
extends RealmBase {
    protected String authentication = null;
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected DirContext context = null;
    protected String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    protected String derefAliases = null;
    public static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    protected static final String info = "org.apache.catalina.realm.JNDIRealm/1.0";
    protected static final String name = "JNDIRealm";
    protected String protocol = null;
    protected boolean adCompat = false;
    protected String referrals = null;
    protected String userBase = "";
    protected String userSearch = null;
    protected MessageFormat userSearchFormat = null;
    protected boolean userSubtree = false;
    protected String userPassword = null;
    protected String[] userPatternArray = null;
    protected String userPattern = null;
    protected MessageFormat[] userPatternFormatArray = null;
    protected String roleBase = "";
    protected MessageFormat roleFormat = null;
    protected String userRoleName = null;
    protected String roleName = null;
    protected String roleSearch = null;
    protected boolean roleSubtree = false;
    protected boolean roleNested = false;
    protected String alternateURL;
    protected int connectionAttempt = 0;
    protected String commonRole = null;
    protected String connectionTimeout = "5000";

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(String derefAliases) {
        this.derefAliases = derefAliases;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean getAdCompat() {
        return this.adCompat;
    }

    public void setAdCompat(boolean adCompat) {
        this.adCompat = adCompat;
    }

    public String getReferrals() {
        return this.referrals;
    }

    public void setReferrals(String referrals) {
        this.referrals = referrals;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserSearch() {
        return this.userSearch;
    }

    public void setUserSearch(String userSearch) {
        this.userSearch = userSearch;
        this.userSearchFormat = userSearch == null ? null : new MessageFormat(userSearch);
    }

    public boolean getUserSubtree() {
        return this.userSubtree;
    }

    public void setUserSubtree(boolean userSubtree) {
        this.userSubtree = userSubtree;
    }

    public String getUserRoleName() {
        return this.userRoleName;
    }

    public void setUserRoleName(String userRoleName) {
        this.userRoleName = userRoleName;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleBase(String roleBase) {
        this.roleBase = roleBase;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleSearch() {
        return this.roleSearch;
    }

    public void setRoleSearch(String roleSearch) {
        this.roleSearch = roleSearch;
        this.roleFormat = roleSearch == null ? null : new MessageFormat(roleSearch);
    }

    public boolean getRoleSubtree() {
        return this.roleSubtree;
    }

    public void setRoleSubtree(boolean roleSubtree) {
        this.roleSubtree = roleSubtree;
    }

    public boolean getRoleNested() {
        return this.roleNested;
    }

    public void setRoleNested(boolean roleNested) {
        this.roleNested = roleNested;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getUserPattern() {
        return this.userPattern;
    }

    public void setUserPattern(String userPattern) {
        this.userPattern = userPattern;
        if (userPattern == null) {
            this.userPatternArray = null;
        } else {
            this.userPatternArray = this.parseUserPatternString(userPattern);
            int len = this.userPatternArray.length;
            this.userPatternFormatArray = new MessageFormat[len];
            for (int i = 0; i < len; ++i) {
                this.userPatternFormatArray[i] = new MessageFormat(this.userPatternArray[i]);
            }
        }
    }

    public String getAlternateURL() {
        return this.alternateURL;
    }

    public void setAlternateURL(String alternateURL) {
        this.alternateURL = alternateURL;
    }

    public String getCommonRole() {
        return this.commonRole;
    }

    public void setCommonRole(String commonRole) {
        this.commonRole = commonRole;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        DirContext context = null;
        Principal principal = null;
        try {
            context = this.open();
            try {
                principal = this.authenticate(context, username, credentials);
            }
            catch (NullPointerException e) {
                this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
                if (context != null) {
                    this.close(context);
                }
                context = this.open();
                principal = this.authenticate(context, username, credentials);
            }
            catch (CommunicationException e) {
                this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
                if (context != null) {
                    this.close(context);
                }
                context = this.open();
                principal = this.authenticate(context, username, credentials);
            }
            catch (ServiceUnavailableException e) {
                this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
                if (context != null) {
                    this.close(context);
                }
                context = this.open();
                principal = this.authenticate(context, username, credentials);
            }
            this.release(context);
            return principal;
        }
        catch (NamingException e) {
            this.containerLog.error((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
            if (context != null) {
                this.close(context);
            }
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"Returning null principal.");
            }
            return null;
        }
    }

    public synchronized Principal authenticate(DirContext context, String username, String credentials) throws NamingException {
        if (username == null || username.equals("") || credentials == null || credentials.equals("")) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"username null or empty: returning null principal.");
            }
            return null;
        }
        if (this.userPatternArray != null) {
            for (int curUserPattern = 0; curUserPattern < this.userPatternFormatArray.length; ++curUserPattern) {
                User user = this.getUser(context, username, credentials, curUserPattern);
                if (user == null) continue;
                try {
                    if (!this.checkCredentials(context, user, credentials)) continue;
                    List<String> roles = this.getRoles(context, user);
                    if (this.containerLog.isDebugEnabled()) {
                        Iterator<String> it = roles.iterator();
                        while (it.hasNext()) {
                            this.containerLog.debug((Object)("Found role: " + it.next()));
                        }
                    }
                    return new GenericPrincipal(this, username, credentials, roles);
                }
                catch (InvalidNameException ine) {
                    this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)ine);
                }
            }
            return null;
        }
        User user = this.getUser(context, username, credentials);
        if (user == null) {
            return null;
        }
        if (!this.checkCredentials(context, user, credentials)) {
            return null;
        }
        List<String> roles = this.getRoles(context, user);
        if (this.containerLog.isDebugEnabled()) {
            Iterator<String> it = roles.iterator();
            while (it.hasNext()) {
                this.containerLog.debug((Object)("Found role: " + it.next()));
            }
        }
        return new GenericPrincipal(this, username, credentials, roles);
    }

    protected User getUser(DirContext context, String username) throws NamingException {
        return this.getUser(context, username, null, -1);
    }

    protected User getUser(DirContext context, String username, String credentials) throws NamingException {
        return this.getUser(context, username, credentials, -1);
    }

    protected User getUser(DirContext context, String username, String credentials, int curUserPattern) throws NamingException {
        User user = null;
        ArrayList<String> list = new ArrayList<String>();
        if (this.userPassword != null) {
            list.add(this.userPassword);
        }
        if (this.userRoleName != null) {
            list.add(this.userRoleName);
        }
        String[] attrIds = new String[list.size()];
        list.toArray(attrIds);
        user = this.userPatternFormatArray != null && curUserPattern >= 0 ? this.getUserByPattern(context, username, credentials, attrIds, curUserPattern) : this.getUserBySearch(context, username, attrIds);
        return user;
    }

    protected User getUserByPattern(DirContext context, String username, String[] attrIds, String dn) throws NamingException {
        if (attrIds == null || attrIds.length == 0) {
            return new User(username, dn, null, null);
        }
        Attributes attrs = null;
        try {
            attrs = context.getAttributes(dn, attrIds);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        if (attrs == null) {
            return null;
        }
        String password = null;
        if (this.userPassword != null) {
            password = this.getAttributeValue(this.userPassword, attrs);
        }
        ArrayList<String> roles = null;
        if (this.userRoleName != null) {
            roles = this.addAttributeValues(this.userRoleName, attrs, roles);
        }
        return new User(username, dn, password, roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUserByPattern(DirContext context, String username, String credentials, String[] attrIds, int curUserPattern) throws NamingException {
        User user = null;
        if (username == null || this.userPatternFormatArray[curUserPattern] == null) {
            return null;
        }
        String dn = this.userPatternFormatArray[curUserPattern].format(new String[]{username});
        try {
            user = this.getUserByPattern(context, username, attrIds, dn);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            block12: {
                block11: {
                    try {
                        context.addToEnvironment("java.naming.security.principal", dn);
                        context.addToEnvironment("java.naming.security.credentials", credentials);
                        user = this.getUserByPattern(context, username, attrIds, dn);
                        Object var10_10 = null;
                        if (this.connectionName == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        if (this.connectionName != null) {
                            context.addToEnvironment("java.naming.security.principal", this.connectionName);
                        } else {
                            context.removeFromEnvironment("java.naming.security.principal");
                        }
                        if (this.connectionPassword != null) {
                            context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
                        } else {
                            context.removeFromEnvironment("java.naming.security.credentials");
                        }
                        throw throwable;
                    }
                    context.addToEnvironment("java.naming.security.principal", this.connectionName);
                    break block12;
                }
                context.removeFromEnvironment("java.naming.security.principal");
            }
            if (this.connectionPassword != null) {
                context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
            }
            context.removeFromEnvironment("java.naming.security.credentials");
            {
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected User getUserBySearch(DirContext context, String username, String[] attrIds) throws NamingException {
        User user;
        NamingEnumeration<SearchResult> results;
        block23: {
            User user2;
            block22: {
                User user3;
                block21: {
                    User user4;
                    block19: {
                        if (username == null) return null;
                        if (this.userSearchFormat == null) {
                            return null;
                        }
                        String filter = this.userSearchFormat.format(new String[]{username});
                        SearchControls constraints = new SearchControls();
                        if (this.userSubtree) {
                            constraints.setSearchScope(2);
                        } else {
                            constraints.setSearchScope(1);
                        }
                        if (attrIds == null) {
                            attrIds = new String[]{};
                        }
                        constraints.setReturningAttributes(attrIds);
                        results = context.search(this.userBase, filter, constraints);
                        try {
                            Attributes attrs;
                            SearchResult result;
                            block20: {
                                block18: {
                                    try {
                                        if (results != null && results.hasMore()) break block18;
                                        user4 = null;
                                    }
                                    catch (PartialResultException ex) {
                                        if (!this.adCompat) {
                                            throw ex;
                                        }
                                        User user5 = null;
                                        Object var14_11 = null;
                                        if (results == null) return user5;
                                        results.close();
                                        return user5;
                                    }
                                    Object var14_10 = null;
                                    if (results == null) return user4;
                                    break block19;
                                }
                                result = results.next();
                                try {
                                    if (!results.hasMore()) break block20;
                                    if (this.containerLog.isInfoEnabled()) {
                                        this.containerLog.info((Object)("username " + username + " has multiple entries"));
                                    }
                                    user3 = null;
                                    break block21;
                                }
                                catch (PartialResultException ex) {
                                    if (this.adCompat) break block20;
                                    throw ex;
                                }
                            }
                            String dn = this.getDistinguishedName(context, this.userBase, result);
                            if (this.containerLog.isTraceEnabled()) {
                                this.containerLog.trace((Object)("  entry found for " + username + " with dn " + dn));
                            }
                            if ((attrs = result.getAttributes()) == null) {
                                user2 = null;
                                break block22;
                            }
                            String password = null;
                            if (this.userPassword != null) {
                                password = this.getAttributeValue(this.userPassword, attrs);
                            }
                            ArrayList<String> roles = null;
                            if (this.userRoleName != null) {
                                roles = this.addAttributeValues(this.userRoleName, attrs, roles);
                            }
                            user = new User(username, dn, password, roles);
                            break block23;
                        }
                        catch (Throwable throwable) {
                            Object var14_15 = null;
                            if (results == null) throw throwable;
                            results.close();
                            throw throwable;
                        }
                    }
                    results.close();
                    return user4;
                }
                Object var14_12 = null;
                if (results == null) return user3;
                results.close();
                return user3;
            }
            Object var14_13 = null;
            if (results == null) return user2;
            results.close();
            return user2;
        }
        Object var14_14 = null;
        if (results == null) return user;
        results.close();
        return user;
    }

    protected boolean checkCredentials(DirContext context, User user, String credentials) throws NamingException {
        boolean validated = false;
        validated = this.userPassword == null ? this.bindAsUser(context, user, credentials) : this.compareCredentials(context, user, credentials);
        if (this.containerLog.isTraceEnabled()) {
            if (validated) {
                this.containerLog.trace((Object)sm.getString("jndiRealm.authenticateSuccess", user.getUserName()));
            } else {
                this.containerLog.trace((Object)sm.getString("jndiRealm.authenticateFailure", user.getUserName()));
            }
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compareCredentials(DirContext context, User info, String credentials) throws NamingException {
        if (info == null || credentials == null) {
            return false;
        }
        String password = info.getPassword();
        if (password == null) {
            return false;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)"  validating credentials");
        }
        boolean validated = false;
        if (this.hasMessageDigest()) {
            if (password.startsWith("{MD5}") || password.startsWith("{SHA}")) {
                JNDIRealm jNDIRealm = this;
                synchronized (jNDIRealm) {
                    password = password.substring(5);
                    this.md.reset();
                    this.md.update(credentials.getBytes());
                    String digestedPassword = new String(Base64.encode(this.md.digest()));
                    validated = password.equals(digestedPassword);
                }
            }
            if (password.startsWith("{SSHA}")) {
                JNDIRealm jNDIRealm = this;
                synchronized (jNDIRealm) {
                    password = password.substring(6);
                    this.md.reset();
                    this.md.update(credentials.getBytes());
                    ByteChunk pwbc = new ByteChunk(password.length());
                    try {
                        pwbc.append(password.getBytes(), 0, password.length());
                    }
                    catch (IOException e) {
                        this.containerLog.error((Object)"Could not append password bytes to chunk: ", (Throwable)e);
                    }
                    CharChunk decoded = new CharChunk();
                    Base64.decode(pwbc, decoded);
                    char[] pwarray = decoded.getBuffer();
                    int saltpos = 20;
                    byte[] hash = new byte[20];
                    for (int i = 0; i < hash.length; ++i) {
                        hash[i] = (byte)pwarray[i];
                    }
                    byte[] salt = new byte[pwarray.length - 20];
                    for (int i = 0; i < salt.length; ++i) {
                        salt[i] = (byte)pwarray[i + 20];
                    }
                    this.md.update(salt);
                    byte[] dp = this.md.digest();
                    validated = Arrays.equals(dp, hash);
                }
            }
            validated = this.digest(credentials).equalsIgnoreCase(password);
        } else {
            validated = this.digest(credentials).equals(password);
        }
        return validated;
    }

    protected boolean bindAsUser(DirContext context, User user, String credentials) throws NamingException {
        boolean validated;
        block10: {
            if (credentials == null || user == null) {
                return false;
            }
            String dn = user.getDN();
            if (dn == null) {
                return false;
            }
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)"  validating credentials by binding as the user");
            }
            context.addToEnvironment("java.naming.security.principal", dn);
            context.addToEnvironment("java.naming.security.credentials", credentials);
            validated = false;
            try {
                if (this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace((Object)("  binding as " + dn));
                }
                context.getAttributes("", null);
                validated = true;
            }
            catch (AuthenticationException e) {
                if (!this.containerLog.isTraceEnabled()) break block10;
                this.containerLog.trace((Object)"  bind attempt failed");
            }
        }
        if (this.connectionName != null) {
            context.addToEnvironment("java.naming.security.principal", this.connectionName);
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getRoles(DirContext context, User user) throws NamingException {
        Object var16_17;
        if (user == null) {
            return null;
        }
        String dn = user.getDN();
        String username = user.getUserName();
        if (dn == null || username == null) {
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  getRoles(" + dn + ")"));
        }
        ArrayList<String> list = new ArrayList<String>();
        List<String> userRoles = user.getRoles();
        if (userRoles != null) {
            list.addAll(userRoles);
        }
        if (this.commonRole != null) {
            list.add(this.commonRole);
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  Found " + list.size() + " user internal roles"));
            for (int i = 0; i < list.size(); ++i) {
                this.containerLog.trace((Object)("  Found user internal role " + (String)list.get(i)));
            }
        }
        if (this.roleFormat == null || this.roleName == null) {
            return list;
        }
        String filter = this.roleFormat.format(new String[]{this.doRFC2254Encoding(dn), username});
        SearchControls controls = new SearchControls();
        if (this.roleSubtree) {
            controls.setSearchScope(2);
        } else {
            controls.setSearchScope(1);
        }
        controls.setReturningAttributes(new String[]{this.roleName});
        NamingEnumeration<SearchResult> results = context.search(this.roleBase, filter, controls);
        if (results == null) {
            return list;
        }
        HashMap<String, String> groupMap = new HashMap<String, String>();
        try {
            try {}
            catch (PartialResultException ex) {
                if (!this.adCompat) {
                    throw ex;
                }
                var16_17 = null;
                results.close();
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            results.close();
            throw throwable;
        }
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) continue;
            String dname = this.getDistinguishedName(context, this.roleBase, result);
            String name = this.getAttributeValue(this.roleName, attrs);
            if (name == null || dname == null) continue;
            groupMap.put(dname, name);
        }
        var16_17 = null;
        results.close();
        Set keys = groupMap.keySet();
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  Found " + keys.size() + " direct roles"));
            for (String key : keys) {
                this.containerLog.trace((Object)("  Found direct role " + key + " -> " + (String)groupMap.get(key)));
            }
        }
        if (this.getRoleNested()) {
            HashMap newGroups = new HashMap(groupMap);
            block11: while (!newGroups.isEmpty()) {
                HashMap<String, String> newThisRound = new HashMap<String, String>();
                Iterator i$ = newGroups.entrySet().iterator();
                while (true) {
                    Object var21_25;
                    block31: {
                        if (i$.hasNext()) {
                            Map.Entry group = i$.next();
                            filter = this.roleFormat.format(new String[]{(String)group.getKey(), (String)group.getValue()});
                            if (this.containerLog.isTraceEnabled()) {
                                this.containerLog.trace((Object)("Perform a nested group search with base " + this.roleBase + " and filter " + filter));
                            }
                            results = context.search(this.roleBase, filter, controls);
                            try {
                                try {}
                                catch (PartialResultException ex) {
                                    if (!this.adCompat) {
                                        throw ex;
                                    }
                                    var21_25 = null;
                                    results.close();
                                }
                                break block31;
                            }
                            catch (Throwable throwable) {
                                var21_25 = null;
                                results.close();
                                throw throwable;
                            }
                        }
                        newGroups = newThisRound;
                        continue block11;
                    }
                    while (results.hasMore()) {
                        SearchResult result = results.next();
                        Attributes attrs = result.getAttributes();
                        if (attrs == null) continue;
                        String dname = this.getDistinguishedName(context, this.roleBase, result);
                        String name = this.getAttributeValue(this.roleName, attrs);
                        if (name == null || dname == null || groupMap.keySet().contains(dname)) continue;
                        groupMap.put(dname, name);
                        newThisRound.put(dname, name);
                        if (!this.containerLog.isTraceEnabled()) continue;
                        this.containerLog.trace((Object)("  Found nested role " + dname + " -> " + name));
                    }
                    var21_25 = null;
                    results.close();
                }
            }
        }
        list.addAll(groupMap.values());
        return list;
    }

    private String getAttributeValue(String attrId, Attributes attrs) throws NamingException {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  retrieving attribute " + attrId));
        }
        if (attrId == null || attrs == null) {
            return null;
        }
        Attribute attr = attrs.get(attrId);
        if (attr == null) {
            return null;
        }
        Object value = attr.get();
        if (value == null) {
            return null;
        }
        String valueString = null;
        valueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
        return valueString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<String> addAttributeValues(String attrId, Attributes attrs, ArrayList<String> values) throws NamingException {
        Attribute attr;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  retrieving values for attribute " + attrId));
        }
        if (attrId == null) return values;
        if (attrs == null) {
            return values;
        }
        if (values == null) {
            values = new ArrayList();
        }
        if ((attr = attrs.get(attrId)) == null) {
            return values;
        }
        NamingEnumeration<?> e = attr.getAll();
        try {
            try {
                while (e.hasMore()) {
                    String value = (String)e.next();
                    values.add(value);
                }
                Object var8_8 = null;
            }
            catch (PartialResultException ex) {
                if (!this.adCompat) {
                    throw ex;
                }
                Object var8_9 = null;
                e.close();
                return values;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            e.close();
            throw throwable;
        }
        e.close();
        return values;
    }

    protected void close(DirContext context) {
        if (context == null) {
            return;
        }
        try {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"Closing directory context");
            }
            context.close();
        }
        catch (NamingException e) {
            this.containerLog.error((Object)sm.getString("jndiRealm.close"), (Throwable)e);
        }
        this.context = null;
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    protected String getPassword(String username) {
        return null;
    }

    @Override
    protected Principal getPrincipal(String username) {
        DirContext context = null;
        Principal principal = null;
        try {
            context = this.open();
            try {
                principal = this.getPrincipal(context, username);
            }
            catch (CommunicationException e) {
                this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
                if (context != null) {
                    this.close(context);
                }
                context = this.open();
                principal = this.getPrincipal(context, username);
            }
            catch (ServiceUnavailableException e) {
                this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
                if (context != null) {
                    this.close(context);
                }
                context = this.open();
                principal = this.getPrincipal(context, username);
            }
            this.release(context);
            return principal;
        }
        catch (NamingException e) {
            this.containerLog.error((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
            if (context != null) {
                this.close(context);
            }
            return null;
        }
    }

    protected synchronized Principal getPrincipal(DirContext context, String username) throws NamingException {
        User user = this.getUser(context, username);
        if (user != null) {
            return new GenericPrincipal(this, user.getUserName(), user.getPassword(), this.getRoles(context, user));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            try {
                this.context = new InitialDirContext(this.getDirectoryContextEnvironment());
            }
            catch (Exception e) {
                this.connectionAttempt = 1;
                this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)e);
                this.context = new InitialDirContext(this.getDirectoryContextEnvironment());
                Object var3_2 = null;
                this.connectionAttempt = 0;
            }
            Object var3_1 = null;
            this.connectionAttempt = 0;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connectionAttempt = 0;
            throw throwable;
        }
        return this.context;
    }

    protected Hashtable<String, String> getDirectoryContextEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.containerLog.isDebugEnabled() && this.connectionAttempt == 0) {
            this.containerLog.debug((Object)("Connecting to URL " + this.connectionURL));
        } else if (this.containerLog.isDebugEnabled() && this.connectionAttempt > 0) {
            this.containerLog.debug((Object)("Connecting to URL " + this.alternateURL));
        }
        env.put("java.naming.factory.initial", this.contextFactory);
        if (this.connectionName != null) {
            env.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPassword != null) {
            env.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.connectionURL != null && this.connectionAttempt == 0) {
            env.put("java.naming.provider.url", this.connectionURL);
        } else if (this.alternateURL != null && this.connectionAttempt > 0) {
            env.put("java.naming.provider.url", this.alternateURL);
        }
        if (this.authentication != null) {
            env.put("java.naming.security.authentication", this.authentication);
        }
        if (this.protocol != null) {
            env.put("java.naming.security.protocol", this.protocol);
        }
        if (this.referrals != null) {
            env.put("java.naming.referral", this.referrals);
        }
        if (this.derefAliases != null) {
            env.put(DEREF_ALIASES, this.derefAliases);
        }
        if (this.connectionTimeout != null) {
            env.put("com.sun.jndi.ldap.connect.timeout", this.connectionTimeout);
        }
        return env;
    }

    protected void release(DirContext context) {
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
        try {
            this.open();
        }
        catch (NamingException e) {
            throw new LifecycleException(sm.getString("jndiRealm.open"), e);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.context);
    }

    protected String[] parseUserPatternString(String userPatternString) {
        if (userPatternString != null) {
            ArrayList<String> pathList = new ArrayList<String>();
            int startParenLoc = userPatternString.indexOf(40);
            if (startParenLoc == -1) {
                return new String[]{userPatternString};
            }
            int startingPoint = 0;
            while (startParenLoc > -1) {
                int endParenLoc = 0;
                while (userPatternString.charAt(startParenLoc + 1) == '|' || startParenLoc != 0 && userPatternString.charAt(startParenLoc - 1) == '\\') {
                    startParenLoc = userPatternString.indexOf("(", startParenLoc + 1);
                }
                endParenLoc = userPatternString.indexOf(")", startParenLoc + 1);
                while (userPatternString.charAt(endParenLoc - 1) == '\\') {
                    endParenLoc = userPatternString.indexOf(")", endParenLoc + 1);
                }
                String nextPathPart = userPatternString.substring(startParenLoc + 1, endParenLoc);
                pathList.add(nextPathPart);
                startingPoint = endParenLoc + 1;
                startParenLoc = userPatternString.indexOf(40, startingPoint);
            }
            return pathList.toArray(new String[0]);
        }
        return null;
    }

    protected String doRFC2254Encoding(String inString) {
        StringBuffer buf = new StringBuffer(inString.length());
        block7: for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected String getDistinguishedName(DirContext context, String base, SearchResult result) throws NamingException {
        if (result.isRelative()) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)("  search returned relative name: " + result.getName()));
            }
            NameParser parser = context.getNameParser("");
            Name contextName = parser.parse(context.getNameInNamespace());
            Name baseName = parser.parse(base);
            Name entryName = parser.parse(new CompositeName(result.getName()).get(0));
            Name name = contextName.addAll(baseName);
            name = name.addAll(entryName);
            return name.toString();
        }
        String absoluteName = result.getName();
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  search returned absolute name: " + result.getName()));
        }
        try {
            NameParser parser = context.getNameParser("");
            URI userNameUri = new URI(absoluteName);
            String pathComponent = userNameUri.getPath();
            if (pathComponent.length() < 1) {
                throw new InvalidNameException("Search returned unparseable absolute name: " + absoluteName);
            }
            Name name = parser.parse(pathComponent.substring(1));
            return name.toString();
        }
        catch (URISyntaxException e) {
            throw new InvalidNameException("Search returned unparseable absolute name: " + absoluteName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class User {
        private final String username;
        private final String dn;
        private final String password;
        private final List<String> roles;

        public User(String username, String dn, String password, List<String> roles) {
            this.username = username;
            this.dn = dn;
            this.password = password;
            this.roles = roles == null ? Collections.emptyList() : Collections.unmodifiableList(roles);
        }

        public String getUserName() {
            return this.username;
        }

        public String getDN() {
            return this.dn;
        }

        public String getPassword() {
            return this.password;
        }

        public List<String> getRoles() {
            return this.roles;
        }
    }
}

