/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.StatusToXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;

public class SearchTemplateResponse
extends ActionResponse
implements StatusToXContent {
    private BytesReference source;
    private SearchResponse response;

    SearchTemplateResponse() {
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public SearchResponse getResponse() {
        return this.response;
    }

    public void setResponse(SearchResponse searchResponse) {
        this.response = searchResponse;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalBytesReference(this.source);
        out.writeOptionalStreamable((Streamable)this.response);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.source = in.readOptionalBytesReference();
        this.response = (SearchResponse)in.readOptionalStreamable(SearchResponse::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasResponse()) {
            this.response.toXContent(builder, params);
        } else {
            builder.rawField("template_output", this.source);
        }
        return builder;
    }

    public RestStatus status() {
        if (this.hasResponse()) {
            return this.response.status();
        }
        return RestStatus.OK;
    }
}

