/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommandRegistry;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AllocationCommands
extends ToXContentToBytes {
    private final List<AllocationCommand> commands = new ArrayList<AllocationCommand>();

    public AllocationCommands(AllocationCommand ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
    }

    public AllocationCommands add(AllocationCommand ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
        return this;
    }

    public List<AllocationCommand> commands() {
        return this.commands;
    }

    public RoutingExplanations execute(RoutingAllocation allocation, boolean explain) {
        RoutingExplanations explanations = new RoutingExplanations();
        for (AllocationCommand command : this.commands) {
            explanations.add(command.execute(allocation, explain));
        }
        return explanations;
    }

    public static AllocationCommands readFrom(StreamInput in) throws IOException {
        AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            commands.add(in.readNamedWriteable(AllocationCommand.class));
        }
        return commands;
    }

    public static void writeTo(AllocationCommands commands, StreamOutput out) throws IOException {
        out.writeVInt(commands.commands.size());
        for (AllocationCommand command : commands.commands) {
            out.writeNamedWriteable(command);
        }
    }

    public static AllocationCommands fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher, AllocationCommandRegistry registry) throws IOException {
        AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            throw new ElasticsearchParseException("No commands", new Object[0]);
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            if (!parser.currentName().equals("commands")) {
                throw new ElasticsearchParseException("expected field name to be named [commands], got [{}] instead", parser.currentName());
            }
            if (!parser.currentName().equals("commands")) {
                throw new ElasticsearchParseException("expected field name to be named [commands], got [{}] instead", parser.currentName());
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("commands should follow with an array element", new Object[0]);
            }
        } else if (token != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("expected either field name [commands], or start array, got [{}] instead", new Object[]{token});
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
                String commandName = parser.currentName();
                token = parser.nextToken();
                commands.add(new AllocationCommand[]{((AllocationCommand.Parser)registry.lookup(commandName, parseFieldMatcher, parser.getTokenLocation())).fromXContent(parser)});
                if (parser.nextToken() == XContentParser.Token.END_OBJECT) continue;
                throw new ElasticsearchParseException("allocation command is malformed, done parsing a command, but didn't get END_OBJECT, got [{}] instead", new Object[]{token});
            }
            throw new ElasticsearchParseException("allocation command is malformed, got [{}] instead", new Object[]{token});
        }
        return commands;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("commands");
        for (AllocationCommand command : this.commands) {
            builder.startObject();
            builder.field(command.name(), command);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllocationCommands other = (AllocationCommands)obj;
        return Objects.equals(this.commands, other.commands);
    }

    public int hashCode() {
        return Objects.hashCode(this.commands);
    }
}

