/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import org.w3c.dom.Element;

public class GoodsContainer
extends FreeColGameObject
implements Ownable {
    private static final Logger logger = Logger.getLogger(Location.class.getName());
    public static final int CARGO_SIZE = 100;
    public static final int HUGE_CARGO_SIZE = 10000;
    private final Map<GoodsType, Integer> storedGoods = new HashMap<GoodsType, Integer>();
    private final Map<GoodsType, Integer> oldStoredGoods = new HashMap<GoodsType, Integer>();
    private Location parent = null;
    public static final String AMOUNT_TAG = "amount";
    public static final String OLD_STORED_GOODS_TAG = "oldStoredGoods";
    public static final String STORED_GOODS_TAG = "storedGoods";
    public static final String TYPE_TAG = "type";

    public GoodsContainer(Game game, Location parent) {
        super(game);
        this.parent = parent;
    }

    public GoodsContainer(Game game, String id) {
        super(game, id);
    }

    public GoodsContainer(Game game, Location parent, Element e) {
        super(game, null);
        this.parent = parent;
        this.readFromXMLElement(e);
    }

    public void setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Null GoodsContainer Location.");
        }
        this.parent = location;
    }

    public boolean contains(Goods g) {
        return this.getGoodsCount(g.getType()) >= g.getAmount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGoodsCount(GoodsType type) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            return this.storedGoods.containsKey(type) ? this.storedGoods.get(type) : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOldGoodsCount(GoodsType type) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                return this.oldStoredGoods.containsKey(type) ? this.oldStoredGoods.get(type) : 0;
            }
        }
    }

    public boolean addGoods(AbstractGoods goods) {
        return this.addGoods(goods.getType(), goods.getAmount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGoods(GoodsType type, int amount) {
        int oldAmount = this.getGoodsCount(type);
        int newAmount = oldAmount + amount;
        if (newAmount < 0) {
            throw new IllegalStateException("Operation would leave " + newAmount + " goods of type " + type + " in Location " + this.parent);
        }
        if (newAmount == 0) {
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.storedGoods.remove(type);
            }
        }
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.put(type, newAmount);
        }
        return true;
    }

    public Goods removeGoods(AbstractGoods goods) {
        return this.removeGoods(goods.getType(), goods.getAmount());
    }

    public Goods removeGoods(GoodsType type) {
        return this.removeGoods(type, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removedGoods;
        int oldAmount = this.getGoodsCount(type);
        if (oldAmount <= 0) {
            return null;
        }
        int newAmount = oldAmount - amount;
        if (newAmount > 0) {
            removedGoods = new Goods(this.getGame(), null, type, amount);
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.storedGoods.put(type, newAmount);
            }
        }
        removedGoods = new Goods(this.getGame(), null, type, oldAmount);
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.remove(type);
        }
        return removedGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAmount(GoodsType goodsType, int newAmount) {
        if (newAmount == 0) {
            Map<GoodsType, Integer> map = this.storedGoods;
            synchronized (map) {
                this.storedGoods.remove(goodsType);
            }
        }
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.put(goodsType, newAmount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearContainers() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            this.storedGoods.clear();
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                this.oldStoredGoods.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAbove(int newAmount) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            if (newAmount <= 0) {
                this.storedGoods.clear();
                return;
            }
            for (GoodsType goodsType : this.storedGoods.keySet()) {
                if (!goodsType.isStorable() || goodsType.limitIgnored() || this.storedGoods.get(goodsType) <= newAmount) continue;
                this.setAmount(goodsType, newAmount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReachedCapacity(int amount) {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            return CollectionUtils.any(this.storedGoods.keySet(), gt -> gt.isStorable() && !gt.limitIgnored() && this.storedGoods.get(gt) > amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceTaken() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            return this.storedGoods.values().stream().mapToInt(amount -> amount % 100 == 0 ? amount / 100 : amount / 100 + 1).sum();
        }
    }

    public Iterator<Goods> getGoodsIterator() {
        return this.getGoods().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goods> getGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            for (GoodsType goodsType : this.storedGoods.keySet()) {
                for (int amount = this.storedGoods.get(goodsType).intValue(); amount > 0; amount -= 100) {
                    totalGoods.add(new Goods(this.getGame(), this.parent, goodsType, amount >= 100 ? 100 : amount));
                }
            }
        }
        return totalGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goods> getCompactGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
                if (entry.getValue() <= 0) continue;
                totalGoods.add(new Goods(this.getGame(), this.parent, entry.getKey(), entry.getValue()));
            }
        }
        return totalGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                this.oldStoredGoods.clear();
                this.oldStoredGoods.putAll(this.storedGoods);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState() {
        Map<GoodsType, Integer> map = this.storedGoods;
        synchronized (map) {
            Map<GoodsType, Integer> map2 = this.oldStoredGoods;
            synchronized (map2) {
                this.storedGoods.clear();
                this.storedGoods.putAll(this.oldStoredGoods);
            }
        }
    }

    public boolean hasChanged() {
        return CollectionUtils.any(this.getSpecification().getGoodsTypeList(), gt -> this.getOldGoodsCount((GoodsType)gt) != this.getGoodsCount((GoodsType)gt));
    }

    public boolean fireChanges() {
        boolean ret = false;
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            int newCount;
            int oldCount = this.getOldGoodsCount(type);
            if (oldCount == (newCount = this.getGoodsCount(type))) continue;
            this.firePropertyChange(type.getId(), oldCount, newCount);
            ret = true;
        }
        return ret;
    }

    @Override
    public Player getOwner() {
        return this.parent instanceof Ownable ? ((Ownable)((Object)this.parent)).getOwner() : null;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException("Can not set GoodsContainer owner");
    }

    @Override
    public void disposeResources() {
        this.clearContainers();
        super.disposeResources();
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.getOwner())) {
            this.writeStorage(xw, STORED_GOODS_TAG, this.storedGoods);
            this.writeStorage(xw, OLD_STORED_GOODS_TAG, this.oldStoredGoods);
        }
    }

    private void writeStorage(FreeColXMLWriter xw, String tag, Map<GoodsType, Integer> storage) throws XMLStreamException {
        if (storage.isEmpty()) {
            return;
        }
        xw.writeStartElement(tag);
        for (GoodsType goodsType : GoodsContainer.getSortedCopy(storage.keySet())) {
            xw.writeStartElement(Goods.getXMLElementTagName());
            xw.writeAttribute(TYPE_TAG, goodsType);
            xw.writeAttribute(AMOUNT_TAG, storage.get(goodsType));
            xw.writeEndElement();
        }
        xw.writeEndElement();
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearContainers();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (OLD_STORED_GOODS_TAG.equals(tag)) {
            this.readStorage(xr, this.oldStoredGoods);
        } else if (STORED_GOODS_TAG.equals(tag)) {
            this.readStorage(xr, this.storedGoods);
        } else {
            super.readChild(xr);
        }
    }

    private void readStorage(FreeColXMLReader xr, Map<GoodsType, Integer> storage) throws XMLStreamException {
        Specification spec = this.getGame().getSpecification();
        while (xr.nextTag() != 2) {
            String tag = xr.getLocalName();
            if (!Goods.getXMLElementTagName().equals(tag)) {
                throw new XMLStreamException("Bogus GoodsContainer tag: " + tag);
            }
            GoodsType goodsType = xr.getType(spec, TYPE_TAG, GoodsType.class, null);
            int amount = xr.getAttribute(AMOUNT_TAG, 0);
            storage.put(goodsType, amount);
            xr.closeTag(tag);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("[").append(this.getId()).append(" [");
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
        }
        sb.setLength(sb.length() - ", ".length());
        sb.append("][");
        for (Map.Entry<GoodsType, Integer> entry : this.oldStoredGoods.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
        }
        sb.setLength(sb.length() - ", ".length());
        sb.append("]]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return GoodsContainer.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goodsContainer";
    }
}

