/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import java.util.Objects;

final class EngineTruffleObject
implements TruffleObject,
ForeignAccess.Factory {
    private final PolyglotEngine engine;
    private final TruffleObject delegate;

    EngineTruffleObject(PolyglotEngine engine, TruffleObject obj) {
        this.engine = engine;
        this.delegate = obj;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return ForeignAccess.create(this);
    }

    TruffleObject getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return true;
    }

    @Override
    public CallTarget accessMessage(Message tree) {
        return Truffle.getRuntime().createCallTarget(new WrappingRoot(TruffleLanguage.class, tree.createNode()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.engine);
        hash = 89 * hash + Objects.hashCode(this.delegate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EngineTruffleObject) {
            EngineTruffleObject other = (EngineTruffleObject)obj;
            return this.engine == other.engine && Objects.equals(this.delegate, other.delegate);
        }
        return false;
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class WrappingRoot
    extends RootNode {
        @Node.Child
        private Node foreignAccess;

        WrappingRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess) {
            super(lang, null, null);
            this.foreignAccess = foreignAccess;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            EngineTruffleObject engineTruffleObject = (EngineTruffleObject)ForeignAccess.getReceiver(frame);
            try {
                return engineTruffleObject.engine.invokeForeign(this.foreignAccess, frame, engineTruffleObject.delegate);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

