/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sticking;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class StickingPolygon {
    private final Vector<StickLine> stick = new Vector();
    private PointDouble lastpoint = null;
    private PointDouble firstpoint = null;
    private final int elementX;
    private final int elementY;
    private final List<PointDouble> allPoints = new ArrayList<PointDouble>();

    public StickingPolygon(int elementX, int elementY) {
        this.elementX = elementX;
        this.elementY = elementY;
    }

    public void addPoint(List<PointDouble> points) {
        for (PointDouble p : points) {
            this.addPoint(p.getX(), p.getY());
        }
    }

    public void addPoint(double x, double y) {
        PointDouble p = new PointDouble((double)this.elementX + x, (double)this.elementY + y);
        this.allPoints.add(p);
        if (this.firstpoint == null) {
            this.firstpoint = p;
        } else {
            this.stick.add(new StickLine(this.lastpoint, p));
        }
        this.lastpoint = p;
    }

    public void addPoint(int x, int y, boolean connectToFirst) {
        this.addPoint(x, y);
        if (connectToFirst) {
            this.allPoints.add(this.firstpoint);
            this.stick.add(new StickLine(this.lastpoint, this.firstpoint));
        }
    }

    public void addRectangle(int x, int y, int width, int height) {
        this.addPoint(x, y);
        this.addPoint(x + width, y);
        this.addPoint(x + width, y + height);
        this.addPoint(x, y + height, true);
    }

    public void addRectangle(Rectangle rect) {
        this.addRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public StickLine getLine(int index) {
        return this.stick.get(index);
    }

    public Vector<StickLine> getStickLines() {
        return this.stick;
    }

    public int isConnected(PointDouble p, int gridSize) {
        int con = -1;
        int i = 0;
        while (i < this.stick.size()) {
            if (this.stick.get(i).isConnected(p, gridSize)) {
                return i;
            }
            ++i;
        }
        return con;
    }

    public String toString() {
        return "StickingPolygon [stick=" + Arrays.toString(this.stick.toArray(new StickLine[this.stick.size()])) + "]";
    }

    public static class StickLine
    extends Line {
        StickLine(PointDouble p1, PointDouble p2) {
            super(p1, p2);
        }

        public PointDouble diffToLine(StickLine s, int inX, int inY) {
            double x = 0.0;
            double y = 0.0;
            if (this.getEnd().x.equals(this.getStart().x)) {
                x = s.getStart().x - (s.getEnd().x - s.getStart().x) - (double)inX;
                if (s.getEnd().x.equals(s.getStart().x)) {
                    y = 0.0;
                    if (s.getStart().y > s.getEnd().y) {
                        if (s.getStart().y < (double)inY) {
                            y = s.getStart().y - (double)inY;
                        } else if (s.getEnd().y > (double)inY) {
                            y = s.getEnd().y - (double)inY;
                        }
                    } else if (s.getEnd().y < (double)inY) {
                        y = s.getEnd().y - (double)inY;
                    } else if (s.getStart().y > (double)inY) {
                        y = s.getStart().y - (double)inY;
                    }
                    return new PointDouble(x, y);
                }
            } else {
                x = ((double)inX - this.getStart().x) * (s.getEnd().x - s.getStart().x) / (this.getEnd().x - this.getStart().x) + s.getStart().x - (double)inX;
            }
            if (this.getEnd().y.equals(this.getStart().y)) {
                y = s.getStart().y - (s.getEnd().y - s.getStart().y) - (double)inY;
                if (s.getEnd().y.equals(s.getStart().y)) {
                    x = 0.0;
                    if (s.getStart().x > s.getEnd().x) {
                        if (s.getStart().x < (double)inX) {
                            x = s.getStart().x - (double)inX;
                        } else if (s.getEnd().x > (double)inX) {
                            x = s.getEnd().x - (double)inX;
                        }
                    } else if (s.getEnd().x < (double)inX) {
                        x = s.getEnd().x - (double)inX;
                    } else if (s.getStart().x > (double)inX) {
                        x = s.getStart().x - (double)inX;
                    }
                }
            } else {
                y = ((double)inY - this.getStart().y) * (s.getEnd().y - s.getStart().y) / (this.getEnd().y - this.getStart().y) + s.getStart().y - (double)inY;
            }
            return new PointDouble(x, y);
        }

        public boolean isConnected(PointDouble p, int maxDistance) {
            double distance = this.getDistanceToPoint(p);
            return distance < (double)maxDistance;
        }
    }
}

