/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument.impl;

import com.oracle.truffle.api.instrument.ASTPrinter;
import com.oracle.truffle.api.instrument.InstrumentationNode;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

@Deprecated
public class DefaultASTPrinter
implements ASTPrinter {
    @Override
    public void printTree(PrintWriter p, Node node, int maxDepth, Node markNode) {
        this.printTree(p, node, maxDepth, markNode, 1);
        p.println();
        p.flush();
    }

    @Override
    public String printTreeToString(Node node, int maxDepth, Node markNode) {
        StringWriter out = new StringWriter();
        this.printTree(new PrintWriter(out), node, maxDepth, markNode);
        return out.toString();
    }

    @Override
    public String printTreeToString(Node node, int maxDepth) {
        return this.printTreeToString(node, maxDepth, null);
    }

    @Override
    public String printNodeWithInstrumentation(Node node) {
        if (node == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DefaultASTPrinter.nodeName(node));
        sb.append("(");
        if (node instanceof InstrumentationNode) {
            sb.append(DefaultASTPrinter.instrumentInfo((InstrumentationNode)((Object)node)));
        }
        sb.append(DefaultASTPrinter.sourceInfo(node));
        sb.append(NodeUtil.printSyntaxTags(node));
        sb.append(")");
        Node parent = node.getParent();
        if (parent instanceof WrapperNode) {
            WrapperNode wrapper = (WrapperNode)((Object)parent);
            sb.append(" Probed");
            sb.append(NodeUtil.printSyntaxTags(wrapper));
        }
        return sb.toString();
    }

    protected void printTree(PrintWriter p, Node node, int maxDepth, Node markNode, int level) {
        if (node == null) {
            p.print("null");
            return;
        }
        p.print(DefaultASTPrinter.nodeName(node));
        p.print("(");
        if (node instanceof InstrumentationNode) {
            p.print(DefaultASTPrinter.instrumentInfo((InstrumentationNode)((Object)node)));
        }
        p.print(DefaultASTPrinter.sourceInfo(node));
        p.print(NodeUtil.printSyntaxTags(node));
        ArrayList<NodeFieldAccessor> childFields = new ArrayList<NodeFieldAccessor>();
        for (NodeFieldAccessor field : NodeClass.get(node).getFields()) {
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD || field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                childFields.add(field);
                continue;
            }
            if (field.getKind() != NodeFieldAccessor.NodeFieldKind.DATA) continue;
        }
        p.print(")");
        if (level <= maxDepth && childFields.size() != 0) {
            p.print(" {");
            for (NodeFieldAccessor field : childFields) {
                Object value = field.loadValue(node);
                if (value == null) {
                    DefaultASTPrinter.printNewLine(p, level);
                    p.print(field.getName());
                    p.print(" = null ");
                    continue;
                }
                if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD) {
                    this.printChild(p, maxDepth, markNode, level, field, value);
                    continue;
                }
                if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                    this.printChildren(p, maxDepth, markNode, level, field, value);
                    continue;
                }
                DefaultASTPrinter.printNewLine(p, level);
                p.print(field.getName());
            }
            DefaultASTPrinter.printNewLine(p, level - 1);
            p.print("}");
        }
    }

    protected void printChildren(PrintWriter p, int maxDepth, Node markNode, int level, NodeFieldAccessor field, Object value) {
        DefaultASTPrinter.printNewLine(p, level);
        p.print(field.getName());
        Node[] children = (Node[])value;
        p.print(" = [");
        String sep = "";
        for (Node child : children) {
            p.print(sep);
            sep = ", ";
            this.printTree(p, child, maxDepth, markNode, level + 1);
        }
        p.print("]");
    }

    protected void printChild(PrintWriter p, int maxDepth, Node markNode, int level, NodeFieldAccessor field, Object value) {
        Node valueNode = (Node)value;
        DefaultASTPrinter.printNewLine(p, level, valueNode == markNode);
        p.print(field.getName());
        p.print(" = ");
        this.printTree(p, valueNode, maxDepth, markNode, level + 1);
    }

    protected static void printNewLine(PrintWriter p, int level, boolean mark) {
        p.println();
        for (int i = 0; i < level; ++i) {
            if (mark && i == 0) {
                p.print(" -->");
                continue;
            }
            p.print("    ");
        }
    }

    protected static void printNewLine(PrintWriter p, int level) {
        DefaultASTPrinter.printNewLine(p, level, false);
    }

    protected static String nodeName(Node node) {
        return node.getClass().getSimpleName();
    }

    protected static String sourceInfo(Node node) {
        SourceSection src = node.getSourceSection();
        if (src != null) {
            if (src.getSource() == null) {
                return src.getShortDescription();
            }
            return src.getSource().getName() + ":" + src.getStartLine();
        }
        return "";
    }

    protected static String instrumentInfo(InstrumentationNode node) {
        String info = node.instrumentationInfo();
        return info == null ? "" : info;
    }
}

