/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JRubyClassLoader
extends ClassDefiningJRubyClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JRubyClassLoader.class);
    private Runnable unloader;
    private File tempdir;

    public JRubyClassLoader(ClassLoader parent) {
        super(parent);
    }

    private File getTempDir() {
        if (this.tempdir == null) {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            long pid2 = Long.parseLong(processName.split("@")[0]);
            File dir = new File(System.getProperty("java.io.tmpdir"), "jruby-" + pid2);
            if (dir.mkdirs()) {
                dir.deleteOnExit();
            }
            this.tempdir = dir;
        }
        return this.tempdir;
    }

    @Override
    public void addURL(URL url) {
        if (url.toString().contains("!/") || !url.getProtocol().equals("file") && !url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            InputStream in = null;
            OutputStream out = null;
            try {
                File f = File.createTempFile("jruby", new File(url.getFile()).getName(), this.getTempDir());
                f.deleteOnExit();
                out = new BufferedOutputStream(new FileOutputStream(f));
                in = new BufferedInputStream(url.openStream());
                int i2 = in.read();
                while (i2 != -1) {
                    out.write(i2);
                    i2 = in.read();
                }
                out.close();
                in.close();
                url = f.toURI().toURL();
            }
            catch (IOException e) {
                throw new RuntimeException("BUG: we can not copy embedded jar to temp directory", e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        LOG.debug(ex);
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        LOG.debug(ex);
                    }
                }
            }
        }
        super.addURL(url);
    }

    public void tearDown(boolean debug) {
        this.close();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception ex) {
            LOG.debug(ex);
        }
        try {
            this.getJDBCDriverUnloader().run();
        }
        catch (Exception ex) {
            LOG.debug(ex);
        }
    }

    @Deprecated
    public synchronized Runnable getJDBCDriverUnloader() {
        if (this.unloader == null) {
            try {
                int bytesRead;
                InputStream unloaderStream = this.getClass().getResourceAsStream("/org/jruby/util/JDBCDriverUnloader.class");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = unloaderStream.read(buf)) != -1) {
                    baos.write(buf, 0, bytesRead);
                }
                Class<?> unloaderClass = this.defineClass("org.jruby.util.JDBCDriverUnloader", baos.toByteArray());
                this.unloader = (Runnable)unloaderClass.newInstance();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.unloader;
    }
}

