/****************************************************************************
** Shared Class code from reading file 'KReportLabelElement.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.2
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
 * Copyright (C) 2001-2007 by OpenMFG, LLC (info@openmfg.com)
 * Copyright (C) 2007-2008 by Adam Pigg (adam@piggz.co.uk)
 * Copyright (C) 2010-2015 Jarosław Staniek <staniek@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KREPORTLABELELEMENT_H
#define KREPORTLABELELEMENT_H

#include "KReportElement.h"
#include "KReportLineStyle.h"

#include <QFont>
#include <QSharedData>

//! @brief The KReportLabelElement class represents a label element of a report design
/*! @note objects of this class are explicitly shared, what means they behave like regular
          C++ pointers, except that by doing reference counting and not deleting the shared
          data object until the reference count is 0, they avoid the dangling pointer problem.
          See <a href="http://doc.qt.io/qt-5/qexplicitlyshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: explicit, operator==, virtual_dtor
class KREPORT_EXPORT KReportLabelElement : public KReportElement
{
public:




    //! @internal data class used to implement explicitly shared class KReportLabelElement.
    //! Provides thread-safe reference counting.
    class Data : public KReportElement::Data
    {
    public:
        Data()
        : alignment(Qt::AlignLeft|Qt::AlignVCenter)
        {
        }

        Data(const KReportElement::Data &other)
         : KReportElement::Data(other)
        {
        }

        Data(const Data &other)
         : KReportElement::Data(other)
         , text(other.text)
         , font(other.font)
         , alignment(other.alignment)
         , borderStyle(other.borderStyle)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual KReportElement::Data* clone() const Q_DECL_OVERRIDE { return new Data(*this); }

        QString text; //!< @see KReportLabelElement::text(), KReportLabelElement::setText()
        QFont font; //!< @see KReportLabelElement::font(), KReportLabelElement::setFont()
        Qt::Alignment alignment; //!< @see KReportLabelElement::alignment(), KReportLabelElement::setAlignment()
        KReportLineStyle borderStyle; //!< @see KReportLabelElement::borderStyle(), KReportLabelElement::setBorderStyle()
    };

    KReportLabelElement()
     : KReportElement(new Data)
    {
    }

    KReportLabelElement(const KReportLabelElement &other)
     : KReportElement(other)
    {
    }

    KReportLabelElement(const KReportElement &other)
     : KReportElement(other)
    {
        if (!data()) { // '@a 'other' does not store suitable data, create a new one and copy what we have
            d = new Data(*d.data());
        }
    }

    virtual ~KReportLabelElement();

    /*!
    @return element's name.
    */
    QString text() const {
        return data()->text;
    }

    /*!
    Sets the element's name to @a name.
    */
    void setText(const QString & text) {
        data()->text = text;
    }

    /*!
    @return element's font.
    */
    QFont font() const {
        return data()->font;
    }

    /*!
    Sets the element's font to @a font.
    */
    void setFont(const QFont & font) {
        data()->font = font;
    }

    /*!
    @return element's text alignment. Default value is Qt::AlignLeft|Qt::AlignVCenter.
    */
    Qt::Alignment alignment() const {
        return data()->alignment;
    }

    /*!
    Sets the element's text alignment to @a alignment.
    */
    void setAlignment(const Qt::Alignment & alignment) {
        data()->alignment = alignment;
    }

    /*!
    @return element's border style.
    */
    KReportLineStyle borderStyle() const {
        return data()->borderStyle;
    }

    /*!
    Sets the element's border style to @a borderStyle.
    */
    void setBorderStyle(const KReportLineStyle & borderStyle) {
        data()->borderStyle = borderStyle;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KReportLabelElement &other) const {
        return data() == other.data();
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KReportLabelElement &other) const {
        return !operator==(other);
    }


    //! Constructs a label with text @a text.
    explicit KReportLabelElement(const QString &text)
        : KReportElement(new Data)
    {
        setText(text);
    }

protected:
    virtual const Data* data() const { return dynamic_cast<const Data*>(KReportElement::d.constData()); }
    virtual Data* data() { return dynamic_cast<Data*>(KReportElement::d.data()); }
};

template<>
KREPORT_EXPORT KReportLabelElement::Data *QSharedDataPointer<KReportLabelElement::Data>::clone();

#endif // KREPORTLABELELEMENT_H
