/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.xmlgraphics.util.Service;

public final class EventExceptionManager {
    private static final Map<String, ExceptionFactory> EXCEPTION_FACTORIES = new HashMap<String, ExceptionFactory>();

    private EventExceptionManager() {
    }

    public static void throwException(Event event, String exceptionClass) throws Throwable {
        if (exceptionClass != null) {
            ExceptionFactory factory = EXCEPTION_FACTORIES.get(exceptionClass);
            if (factory != null) {
                throw factory.createException(event);
            }
            throw new IllegalArgumentException("No such ExceptionFactory available: " + exceptionClass);
        }
        String msg = EventFormatter.format(event);
        Throwable t = null;
        for (Object o : event.getParams().values()) {
            if (!(o instanceof Throwable)) continue;
            t = (Throwable)o;
            break;
        }
        if (t != null) {
            throw new RuntimeException(msg, t);
        }
        throw new RuntimeException(msg);
    }

    static {
        Iterator iter = Service.providers(ExceptionFactory.class);
        while (iter.hasNext()) {
            ExceptionFactory factory = (ExceptionFactory)iter.next();
            EXCEPTION_FACTORIES.put(factory.getExceptionClass().getName(), factory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionFactory {
        public Throwable createException(Event var1);

        public Class<? extends Exception> getExceptionClass();
    }
}

