/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.util.diff.Diff;
import org.jetbrains.kotlin.com.intellij.util.diff.FilesTooBigForDiffException;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    private final CharSequence myOldString;
    private final int myOldLength;
    private final CharSequence myNewString;
    private final int myNewLength;
    private boolean isOnlyOneLineChangedCalculated;
    private boolean isOnlyOneLineChanged;
    private boolean isStartOldIndexCalculated;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private static final Diff.Change TOO_BIG_FILE = new Diff.Change(0, 0, 0, 0, null){};
    private int myOptimizedLineShift;
    private int myOptimizedOldLineShift;
    private final int myInitialStartOffset;
    private final int myInitialOldLength;

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document, int offset2, CharSequence oldString, CharSequence newString, long oldTimeStamp, boolean bl) {
        void wholeTextReplaced;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        this(document, offset2, oldString, newString, oldTimeStamp, (boolean)wholeTextReplaced, offset2, oldString == null ? 0 : oldString.length());
    }

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document, int offset2, CharSequence oldString, CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced, int initialStartOffset, int n) {
        void initialOldLength;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        super(document);
        this.isOnlyOneLineChangedCalculated = false;
        this.isStartOldIndexCalculated = false;
        this.myOptimizedLineShift = -1;
        this.myOptimizedOldLineShift = -1;
        this.myOffset = offset2;
        this.myOldString = oldString == null ? "" : oldString;
        this.myOldLength = this.myOldString.length();
        this.myNewString = newString == null ? "" : newString;
        this.myNewLength = this.myNewString.length();
        this.myInitialStartOffset = initialStartOffset;
        this.myInitialOldLength = initialOldLength;
        this.myOldTimeStamp = oldTimeStamp;
        if (this.getDocument().getTextLength() == 0) {
            this.isOnlyOneLineChangedCalculated = true;
            this.isOnlyOneLineChanged = false;
            this.myIsWholeDocReplaced = false;
        } else {
            this.myIsWholeDocReplaced = wholeTextReplaced;
        }
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return this.myOldLength;
    }

    @Override
    public int getNewLength() {
        return this.myNewLength;
    }

    @Override
    @NotNull
    public CharSequence getOldFragment() {
        CharSequence charSequence = this.myOldString;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getOldFragment"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getNewFragment() {
        CharSequence charSequence = this.myNewString;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getNewFragment"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = (Document)this.getSource();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getDocument"));
        }
        return document;
    }

    public int getInitialStartOffset() {
        return this.myInitialStartOffset;
    }

    public int getInitialOldLength() {
        return this.myInitialOldLength;
    }

    @Override
    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    @Override
    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + ", myOldString='" + this.myOldString + "', myNewString='" + this.myNewString + "']" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    @Override
    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiffStrict(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        return Diff.translateLine(change, line);
    }

    private Diff.Change reBuildDiffIfNeeded() throws FilesTooBigForDiffException {
        if (this.myChange == TOO_BIG_FILE) {
            throw new FilesTooBigForDiffException(0);
        }
        if (this.myChange == null) {
            try {
                this.myChange = Diff.buildChanges(this.myOldString, this.myNewString);
            }
            catch (FilesTooBigForDiffException e) {
                this.myChange = TOO_BIG_FILE;
                throw e;
            }
        }
        return this.myChange;
    }
}

