/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MemberLookupHelper {
    private final PsiMember myMember;
    private final boolean myMergedOverloads;
    @Nullable
    private final PsiClass myContainingClass;
    private boolean myShouldImport;

    public MemberLookupHelper(List<PsiMethod> overloads, PsiClass containingClass, boolean shouldImport) {
        this((PsiMember)overloads.get(0), containingClass, shouldImport, true);
    }

    public MemberLookupHelper(PsiMember member, @Nullable PsiClass containingClass, boolean shouldImport, boolean mergedOverloads) {
        this.myMember = member;
        this.myContainingClass = containingClass;
        this.myShouldImport = shouldImport;
        this.myMergedOverloads = mergedOverloads;
    }

    public PsiMember getMember() {
        return this.myMember;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myShouldImport = shouldImportStatic;
    }

    public boolean willBeImported() {
        return this.myShouldImport;
    }

    public void renderElement(LookupElementPresentation presentation, boolean showClass, boolean showPackage, PsiSubstitutor substitutor) {
        PsiType type;
        String location;
        String className = this.myContainingClass == null ? "???" : this.myContainingClass.getName();
        String memberName = this.myMember.getName();
        if (showClass && StringUtil.isNotEmpty((String)className)) {
            presentation.setItemText(className + "." + memberName);
        } else {
            presentation.setItemText(memberName);
        }
        String qname = this.myContainingClass == null ? "" : this.myContainingClass.getQualifiedName();
        String pkg = qname == null ? "" : StringUtil.getPackageName((String)qname);
        String string = location = showPackage && StringUtil.isNotEmpty((String)pkg) ? " (" + pkg + ")" : "";
        String params = this.myMergedOverloads ? "(...)" : (this.myMember instanceof PsiMethod ? PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)this.myMember), (PsiSubstitutor)substitutor, (int)256, (int)3) : "");
        presentation.clearTail();
        presentation.appendTailText(params, false);
        if (this.myShouldImport && StringUtil.isNotEmpty((String)className)) {
            presentation.appendTailText(" in " + className + location, true);
        } else {
            presentation.appendTailText(location, true);
        }
        PsiType psiType = type = this.myMember instanceof PsiMethod ? ((PsiMethod)this.myMember).getReturnType() : ((PsiField)this.myMember).getType();
        if (type != null) {
            presentation.setTypeText(substitutor.substitute(type).getPresentableText());
        }
    }
}

