/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.CleanupOnScopeIntention;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.EditCleanupProfileIntentionAction;
import com.intellij.codeInsight.daemon.impl.EditorNotificationActions;
import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.ShowIntentionsPass");
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo;
    private volatile boolean myShowBulb;
    private volatile boolean myHasToRecreate;

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file2, int passId) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getAvailableActions"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getAvailableActions"));
        }
        int offset = ((EditorEx)editor).getExpectedCaretOffset();
        Project project2 = file2.getProject();
        ArrayList<HighlightInfo.IntentionActionDescriptor> result2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project2, HighlightSeverity.INFORMATION, offset, true, (Processor<HighlightInfo>)((Processor)info -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$getAvailableActions$0"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$getAvailableActions$0"));
            }
            ShowIntentionsPass.addAvailableActionsForGroups(info, editor, file2, result2, passId, offset);
            return true;
        }));
        ArrayList<HighlightInfo.IntentionActionDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getAvailableActions"));
        }
        return arrayList;
    }

    private static void addAvailableActionsForGroups(@NotNull HighlightInfo info, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull List<HighlightInfo.IntentionActionDescriptor> outList, int group, int offset) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableActionsForGroups"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableActionsForGroups"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableActionsForGroups"));
        }
        if (outList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outList", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableActionsForGroups"));
        }
        if (info.quickFixActionMarkers == null) {
            return;
        }
        if (group != -1 && group != info.getGroup()) {
            return;
        }
        boolean fixRangeIsNotEmpty = !info.getFixTextRange().isEmpty();
        Editor injectedEditor = null;
        PsiFile injectedFile = null;
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            PsiFile fileToUse;
            Editor editorToUse;
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range = (RangeMarker)pair.second;
            if (!range.isValid() || fixRangeIsNotEmpty && ShowIntentionsPass.isEmpty((Segment)range) || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)actionInGroup.getAction())) continue;
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            Project project2 = file2.getProject();
            if (start > offset || offset > end) continue;
            if (info.isFromInjection()) {
                if (injectedEditor == null) {
                    injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
                    injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                }
                editorToUse = injectedEditor;
                fileToUse = injectedFile;
            } else {
                editorToUse = editor;
                fileToUse = file2;
            }
            if (!actionInGroup.getAction().isAvailable(project2, editorToUse, fileToUse)) continue;
            outList.add(actionInGroup);
        }
    }

    private static boolean isEmpty(@NotNull Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "isEmpty"));
        }
        return segment.getEndOffset() <= segment.getStartOffset();
    }

    ShowIntentionsPass(@NotNull Project project2, @NotNull Editor editor, int passId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "<init>"));
        }
        super(project2, editor.getDocument(), false);
        this.myIntentionsInfo = new IntentionsInfo();
        this.myPassIdToShowIntentionsFor = passId;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        this.myFile = documentManager.getPsiFile(this.myEditor.getDocument());
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "doCollectInformation"));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state != null && !state.isFinished()) {
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        this.getIntentionActionsToShow();
        this.updateActions(codeAnalyzer);
    }

    @Override
    public void doApplyInformationToEditor() {
        Point xy;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        LogicalPosition caretPos = this.myEditor.getCaretModel().getLogicalPosition();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(xy = this.myEditor.logicalPositionToXY(caretPos))) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (this.myShowBulb && (state == null || state.isFinished()) && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(false)) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            codeAnalyzer.setLastIntentionHint(this.myProject, this.myFile, this.myEditor, this.myIntentionsInfo, this.myHasToRecreate);
        }
    }

    private void getIntentionActionsToShow() {
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor);
        if (this.myFile instanceof IntentionFilterOwner) {
            IntentionFilterOwner.IntentionActionsFilter actionsFilter = ((IntentionFilterOwner)this.myFile).getIntentionActionsFilter();
            if (actionsFilter == null) {
                return;
            }
            if (actionsFilter != IntentionFilterOwner.IntentionActionsFilter.EVERYTHING_AVAILABLE) {
                this.myIntentionsInfo.filterActions(actionsFilter);
            }
        }
        if (this.myIntentionsInfo.isEmpty()) {
            return;
        }
        this.myShowBulb = !this.myIntentionsInfo.guttersToShow.isEmpty() || !this.myIntentionsInfo.notificationActionsToShow.isEmpty() || ContainerUtil.exists((Iterable)ContainerUtil.concat((List[])new List[]{this.myIntentionsInfo.errorFixesToShow, this.myIntentionsInfo.inspectionFixesToShow, this.myIntentionsInfo.intentionsToShow}), descriptor -> IntentionManagerSettings.getInstance().isShowLightBulb(descriptor.getAction()));
    }

    private static boolean appendCleanupCode(@NotNull List<HighlightInfo.IntentionActionDescriptor> actionDescriptors, @NotNull PsiFile file2) {
        if (actionDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionDescriptors", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "appendCleanupCode"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "appendCleanupCode"));
        }
        for (HighlightInfo.IntentionActionDescriptor descriptor : actionDescriptors) {
            if (!descriptor.canCleanup((PsiElement)file2)) continue;
            ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
            options.add(EditCleanupProfileIntentionAction.INSTANCE);
            options.add(CleanupOnScopeIntention.INSTANCE);
            actionDescriptors.add(new HighlightInfo.IntentionActionDescriptor(CleanupAllIntention.INSTANCE, options, "Code Cleanup Options"));
            return true;
        }
        return false;
    }

    private void updateActions(@NotNull DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (codeAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeAnalyzer", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "updateActions"));
        }
        IntentionHintComponent hintComponent = codeAnalyzer.getLastIntentionHint();
        if (!this.myShowBulb || hintComponent == null || !hintComponent.isForEditor(this.myEditor)) {
            return;
        }
        IntentionHintComponent.PopupUpdateResult result2 = hintComponent.updateActions(this.myIntentionsInfo);
        if (result2 != IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE && result2 == IntentionHintComponent.PopupUpdateResult.CHANGED_INVISIBLE) {
            this.myHasToRecreate = true;
        }
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getActionsToShow"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getActionsToShow"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getActionsToShow"));
        }
        PsiElement psiElement = hostFile.findElementAt(hostEditor.getCaretModel().getOffset());
        LOG.assertTrue(psiElement == null || psiElement.isValid(), (Object)psiElement);
        int offset = hostEditor.getCaretModel().getOffset();
        Project project2 = hostFile.getProject();
        List<HighlightInfo.IntentionActionDescriptor> fixes = ShowIntentionsPass.getAvailableActions(hostEditor, hostFile, passIdToShowIntentionsFor);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
        Document hostDocument = hostEditor.getDocument();
        HighlightInfo infoAtCursor = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(hostDocument, offset, true);
        if (infoAtCursor == null) {
            intentions.errorFixesToShow.addAll(fixes);
        } else {
            boolean isError = infoAtCursor.getSeverity() == HighlightSeverity.ERROR;
            for (HighlightInfo.IntentionActionDescriptor fix : fixes) {
                if (fix.isError() && isError) {
                    intentions.errorFixesToShow.add(fix);
                    continue;
                }
                intentions.inspectionFixesToShow.add(fix);
            }
        }
        for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
            Pair<PsiFile, Editor> place = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<PsiFile, Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action)));
            if (place == null) continue;
            ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
            enableDisableIntentionAction.add(new IntentionHintComponent.EnableDisableIntentionAction(action));
            enableDisableIntentionAction.add(new IntentionHintComponent.EditIntentionSettingsAction(action));
            HighlightInfo.IntentionActionDescriptor descriptor = new HighlightInfo.IntentionActionDescriptor(action, enableDisableIntentionAction, null);
            if (fixes.contains(descriptor)) continue;
            intentions.intentionsToShow.add(descriptor);
        }
        int line = hostDocument.getLineNumber(offset);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(hostDocument, project2, true);
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        model.processRangeHighlightersOverlappingWith(hostDocument.getLineStartOffset(line), hostDocument.getLineEndOffset(line), (Processor<? super RangeHighlighterEx>)processor2);
        for (RangeHighlighterEx highlighter : result2) {
            GutterIntentionAction.addActions(project2, hostEditor, hostFile, highlighter, intentions.guttersToShow);
        }
        boolean cleanup = ShowIntentionsPass.appendCleanupCode(intentions.inspectionFixesToShow, hostFile);
        if (!cleanup) {
            ShowIntentionsPass.appendCleanupCode(intentions.errorFixesToShow, hostFile);
        }
        EditorNotificationActions.collectDescriptorsForEditor(hostEditor, intentions.notificationActionsToShow);
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> guttersToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> notificationActionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();

        private void filterActions(@NotNull IntentionFilterOwner.IntentionActionsFilter actionsFilter) {
            if (actionsFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionsFilter", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo", "filterActions"));
            }
            IntentionsInfo.filter(this.intentionsToShow, actionsFilter);
            IntentionsInfo.filter(this.errorFixesToShow, actionsFilter);
            IntentionsInfo.filter(this.inspectionFixesToShow, actionsFilter);
            IntentionsInfo.filter(this.guttersToShow, actionsFilter);
        }

        private static void filter(@NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull IntentionFilterOwner.IntentionActionsFilter actionsFilter) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo", "filter"));
            }
            if (actionsFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionsFilter", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo", "filter"));
            }
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                if (actionsFilter.isAvailable(actionDescriptor.getAction())) continue;
                it.remove();
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty() && this.notificationActionsToShow.isEmpty();
        }

        @NonNls
        public String toString() {
            return "Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Intentions: " + this.intentionsToShow + "; Gutters: " + this.guttersToShow + "Notifications: " + this.notificationActionsToShow;
        }
    }
}

