/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;

public class GotoInstruction
extends Instruction {
    private ControlFlow.ControlFlowOffset myOffset;

    public GotoInstruction(ControlFlow.ControlFlowOffset myOffset) {
        this.myOffset = myOffset;
    }

    public int getOffset() {
        return this.myOffset.getInstructionOffset();
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        Instruction nextInstruction = runner.getInstruction(this.getOffset());
        return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, stateBefore)};
    }

    public String toString() {
        return "GOTO: " + this.getOffset();
    }

    public void setOffset(final int offset) {
        this.myOffset = new ControlFlow.ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return offset;
            }
        };
    }
}

