/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountedCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplierCompleter<T>
extends CountedCompleter<Void> {
    private final boolean runInReadAction;
    private final ProgressIndicator progressIndicator;
    @NotNull
    private final List<T> array;
    @NotNull
    private final Processor<? super T> processor;
    private final int lo;
    private final int hi;
    private final ApplierCompleter<T> next;
    volatile Throwable throwable;
    private static final AtomicFieldUpdater<ApplierCompleter, Throwable> throwableUpdater = AtomicFieldUpdater.forFieldOfType(ApplierCompleter.class, Throwable.class);
    private final Collection<ApplierCompleter<T>> failedSubTasks;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.progressIndicator.cancel();
        return super.cancel(mayInterruptIfRunning);
    }

    ApplierCompleter(ApplierCompleter<T> parent, boolean runInReadAction, @NotNull ProgressIndicator progressIndicator, @NotNull List<T> array, @NotNull Processor<? super T> processor2, int lo, int hi, @NotNull Collection<ApplierCompleter<T>> failedSubTasks, ApplierCompleter<T> next) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (failedSubTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedSubTasks", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        super(parent);
        this.runInReadAction = runInReadAction;
        this.progressIndicator = progressIndicator;
        this.array = array;
        this.processor = processor2;
        this.lo = lo;
        this.hi = hi;
        this.failedSubTasks = failedSubTasks;
        this.next = next;
    }

    @Override
    public void compute() {
        this.wrapInReadActionAndIndicator(this::execAndForkSubTasks);
    }

    private void wrapInReadActionAndIndicator(@NotNull Runnable process2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/concurrency/ApplierCompleter", "wrapInReadActionAndIndicator"));
        }
        Runnable toRun = this.runInReadAction ? () -> {
            if (process2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/concurrency/ApplierCompleter", "lambda$wrapInReadActionAndIndicator$0"));
            }
            if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(process2)) {
                this.failedSubTasks.add(this);
                this.doComplete(this.throwable);
            }
        } : process2;
        ProgressIndicator existing = ProgressManager.getInstance().getProgressIndicator();
        if (existing == this.progressIndicator) {
            toRun.run();
        } else {
            ProgressManager.getInstance().executeProcessUnderProgress(toRun, this.progressIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ApplierCompleter<T> execAndForkSubTasks() {
        int hi = this.hi;
        long start = System.currentTimeMillis();
        ApplierCompleter<T> right = null;
        Throwable throwable = null;
        try {
            for (int i = this.lo; i < hi; ++i) {
                this.progressIndicator.checkCanceled();
                if (!this.processor.process(this.array.get(i))) {
                    throw new ComputationAbortedException();
                }
                long finish = System.currentTimeMillis();
                long elapsed = finish - start;
                if (elapsed <= 5L || hi - i < 2 || ApplierCompleter.getSurplusQueuedTaskCount() > JobSchedulerImpl.CORES_COUNT) continue;
                int mid = i + hi >>> 1;
                right = new ApplierCompleter<T>(this, this.runInReadAction, this.progressIndicator, this.array, this.processor, mid, hi, this.failedSubTasks, right);
                this.addToPendingCount(1);
                right.fork();
                hi = mid;
                start = finish;
            }
            if (right != null) {
                throwable = super.tryToExecAllList();
            }
        }
        catch (Throwable e) {
            this.cancelProgress();
            throwable = e;
        }
        finally {
            this.doComplete(ApplierCompleter.moreImportant(throwable, this.throwable));
        }
        return right;
    }

    private static Throwable moreImportant(Throwable throwable1, Throwable throwable2) {
        Throwable result2 = throwable1 == null ? throwable2 : (throwable2 == null ? throwable1 : (throwable1 instanceof ProcessCanceledException ? throwable2 : throwable1));
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doComplete(Throwable throwable) {
        ApplierCompleter a;
        ApplierCompleter child = a = this;
        while (true) {
            Throwable newThrowable;
            Throwable oldThrowable;
            if ((oldThrowable = a.throwable) != (newThrowable = ApplierCompleter.moreImportant(oldThrowable, throwable)) && !throwableUpdater.compareAndSet((Object)a, (Object)oldThrowable, (Object)newThrowable)) {
                continue;
            }
            throwable = newThrowable;
            if (a.getPendingCount() == 0) {
                a.onCompletion(child);
                child = a;
                if ((a = (ApplierCompleter)a.getCompleter()) != null) continue;
                child.quietlyComplete();
                return;
            }
            if (a.decrementPendingCountUnlessZero() != 0) return;
        }
    }

    private void cancelProgress() {
        if (!this.progressIndicator.isCanceled()) {
            this.progressIndicator.cancel();
        }
    }

    private Throwable tryToExecAllList() {
        ApplierCompleter<T> right = this;
        Throwable result2 = this.throwable;
        while (right != null) {
            if (right.tryUnfork()) {
                right.execAndForkSubTasks();
                result2 = ApplierCompleter.moreImportant(result2, right.throwable);
            }
            right = right.next;
        }
        return result2;
    }

    boolean completeTaskWhichFailToAcquireReadAction() {
        boolean[] result2 = new boolean[]{true};
        for (ApplierCompleter task : this.failedSubTasks) {
            ApplicationManager.getApplication().runReadAction(() -> task.wrapInReadActionAndIndicator(() -> {
                for (int i = task.lo; i < task.hi; ++i) {
                    if (task.processor.process(task.array.get(i))) continue;
                    result2[0] = false;
                    break;
                }
            }));
        }
        return result2[0];
    }

    public String toString() {
        return "(" + this.lo + "-" + this.hi + ")" + (this.getCompleter() == null ? "" : " parent: " + this.getCompleter());
    }

    static class ComputationAbortedException
    extends RuntimeException {
        ComputationAbortedException() {
        }
    }
}

