/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JVMNameUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.JVMNameUtil");
    public static final String CONSTRUCTOR_NAME = "<init>";

    @Nullable
    public static String getPrimitiveSignature(String typeName) {
        if (PsiType.BOOLEAN.getCanonicalText().equals(typeName)) {
            return "Z";
        }
        if (PsiType.BYTE.getCanonicalText().equals(typeName)) {
            return "B";
        }
        if (PsiType.CHAR.getCanonicalText().equals(typeName)) {
            return "C";
        }
        if (PsiType.SHORT.getCanonicalText().equals(typeName)) {
            return "S";
        }
        if (PsiType.INT.getCanonicalText().equals(typeName)) {
            return "I";
        }
        if (PsiType.LONG.getCanonicalText().equals(typeName)) {
            return "J";
        }
        if (PsiType.FLOAT.getCanonicalText().equals(typeName)) {
            return "F";
        }
        if (PsiType.DOUBLE.getCanonicalText().equals(typeName)) {
            return "D";
        }
        if (PsiType.VOID.getCanonicalText().equals(typeName)) {
            return "V";
        }
        return null;
    }

    private static void appendJVMSignature(JVMNameBuffer buffer, PsiType type) {
        if (type == null) {
            return;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
        if (psiType instanceof PsiArrayType) {
            buffer.append(new JVMRawText("["));
            JVMNameUtil.appendJVMSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            JVMName jvmName = JVMNameUtil.getJVMQualifiedName(psiType);
            JVMNameUtil.appendJvmClassQualifiedName(buffer, jvmName);
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JVMNameUtil.getPrimitiveSignature(psiType.getCanonicalText()));
        } else {
            LOG.error("unknown type " + type.getCanonicalText());
        }
    }

    private static void appendJvmClassQualifiedName(JVMNameBuffer buffer, final JVMName jvmName) {
        buffer.append("L");
        if (jvmName instanceof JVMRawText) {
            buffer.append(((JVMRawText)jvmName).getName().replace('.', '/'));
        } else {
            buffer.append(new JVMName(){

                @Override
                public String getName(DebugProcessImpl process2) throws EvaluateException {
                    return jvmName.getName(process2).replace('.', '/');
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    return jvmName.getDisplayName(debugProcess);
                }
            });
        }
        buffer.append(";");
    }

    @NotNull
    public static JVMName getJVMRawText(String qualifiedName) {
        JVMRawText jVMRawText = new JVMRawText(qualifiedName);
        if (jVMRawText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMRawText"));
        }
        return jVMRawText;
    }

    public static JVMName getJVMQualifiedName(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            JVMName jvmName = JVMNameUtil.getJVMQualifiedName(arrayType.getComponentType());
            JVMNameBuffer buffer = new JVMNameBuffer();
            buffer.append(jvmName);
            buffer.append("[]");
            return buffer.toName();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass == null) {
            return JVMNameUtil.getJVMRawText(psiType.getCanonicalText());
        }
        return JVMNameUtil.getJVMQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMQualifiedName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/debugger/engine/JVMNameUtil", "getJVMQualifiedName"));
        }
        String name = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (name != null) {
            JVMName jVMName = JVMNameUtil.getJVMRawText(name);
            if (jVMName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMQualifiedName"));
            }
            return jVMName;
        }
        JVMClassAt jVMClassAt = new JVMClassAt(SourcePosition.createFromElement((PsiElement)psiClass));
        if (jVMClassAt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMQualifiedName"));
        }
        return jVMClassAt;
    }

    @Nullable
    public static JVMName getContextClassJVMQualifiedName(@Nullable SourcePosition pos) {
        PsiClass psiClass = JVMNameUtil.getClassAt(pos);
        if (psiClass == null) {
            return null;
        }
        String name = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (name != null) {
            return JVMNameUtil.getJVMRawText(name);
        }
        return new JVMClassAt(pos);
    }

    @Nullable
    public static String getNonAnonymousClassName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/debugger/engine/JVMNameUtil", "getNonAnonymousClassName"));
        }
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            return null;
        }
        String name = aClass.getName();
        if (name == null) {
            return null;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parentClass != null) {
            String parentName = JVMNameUtil.getNonAnonymousClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + name;
        }
        return DebuggerManager.getInstance((Project)aClass.getProject()).getVMClassQualifiedName(aClass);
    }

    @NotNull
    public static JVMName getJVMConstructorSignature(@Nullable PsiMethod method, @Nullable PsiClass declaringClass) {
        JVMName jVMName = JVMNameUtil.getJVMSignature(method, true, declaringClass);
        if (jVMName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMConstructorSignature"));
        }
        return jVMName;
    }

    @NotNull
    public static JVMName getJVMSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/JVMNameUtil", "getJVMSignature"));
        }
        JVMName jVMName = JVMNameUtil.getJVMSignature(method, method.isConstructor(), method.getContainingClass());
        if (jVMName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMSignature"));
        }
        return jVMName;
    }

    @NotNull
    public static String getJVMMethodName(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/JVMNameUtil", "getJVMMethodName"));
        }
        String string = method.isConstructor() ? CONSTRUCTOR_NAME : method.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMMethodName"));
        }
        return string;
    }

    @NotNull
    private static JVMName getJVMSignature(@Nullable PsiMethod method, boolean constructor, @Nullable PsiClass declaringClass) {
        PsiClass outerClass;
        JVMNameBuffer signature = new JVMNameBuffer();
        signature.append("(");
        if (constructor && declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static")) {
            JVMNameUtil.appendJvmClassQualifiedName(signature, JVMNameUtil.getJVMQualifiedName(outerClass));
        }
        if (method != null) {
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                JVMNameUtil.appendJVMSignature(signature, psiParameter.getType());
            }
        }
        signature.append(")");
        if (!constructor && method != null) {
            JVMNameUtil.appendJVMSignature(signature, method.getReturnType());
        } else {
            signature.append(new JVMRawText("V"));
        }
        JVMName jVMName = signature.toName();
        if (jVMName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JVMNameUtil", "getJVMSignature"));
        }
        return jVMName;
    }

    @Nullable
    public static PsiClass getClassAt(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        PsiElement element = position.getElementAt();
        return element != null && element.isValid() ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false) : null;
    }

    @Nullable
    public static String getSourcePositionClassDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        List<ReferenceType> allClasses;
        String qName;
        if (position == null) {
            return null;
        }
        PsiFile positionFile = position.getFile();
        if (positionFile instanceof JspFile) {
            return positionFile.getName();
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(position);
        if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
            return qName;
        }
        if (debugProcess != null && debugProcess.isAttached() && !(allClasses = debugProcess.getPositionManager().getAllClasses(position)).isEmpty()) {
            return allClasses.get(0).name();
        }
        if (psiClass == null) {
            if (positionFile instanceof PsiClassOwner) {
                return positionFile.getName();
            }
            return DebuggerBundle.message((String)"string.file.line.position", (Object[])new Object[]{positionFile.getName(), position.getLine()});
        }
        return JVMNameUtil.calcClassDisplayName(psiClass);
    }

    static String calcClassDisplayName(final PsiClass aClass) {
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parent == null) {
            return null;
        }
        String name = aClass.getName();
        if (name != null) {
            return JVMNameUtil.calcClassDisplayName(parent) + "$" + name;
        }
        final Ref classIndex = new Ref((Object)0);
        try {
            parent.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitAnonymousClass(PsiAnonymousClass cls) {
                    classIndex.set((Object)((Integer)classIndex.get() + 1));
                    if (aClass.equals(cls)) {
                        throw new ProcessCanceledException();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return JVMNameUtil.calcClassDisplayName(parent) + "$" + classIndex.get();
    }

    @Nullable
    public static String getSourcePositionPackageDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        String className;
        int dotIndex;
        List<ReferenceType> allClasses;
        String name;
        String qName;
        PsiClass toplevel;
        if (position == null) {
            return null;
        }
        PsiFile positionFile = position.getFile();
        if (positionFile instanceof JspFile) {
            PsiDirectory dir = positionFile.getContainingDirectory();
            return dir != null ? dir.getVirtualFile().getPresentableUrl() : null;
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(position);
        if (psiClass != null && (toplevel = PsiUtil.getTopLevelClass((PsiElement)psiClass)) != null && (qName = toplevel.getQualifiedName()) != null) {
            int i = qName.lastIndexOf(46);
            return i > 0 ? qName.substring(0, i) : "";
        }
        if (positionFile instanceof PsiClassOwner && !StringUtil.isEmpty((String)(name = ((PsiClassOwner)positionFile).getPackageName()))) {
            return name;
        }
        if (debugProcess != null && debugProcess.isAttached() && !(allClasses = debugProcess.getPositionManager().getAllClasses(position)).isEmpty() && (dotIndex = (className = allClasses.get(0).name()).lastIndexOf(46)) >= 0) {
            return className.substring(0, dotIndex);
        }
        return "";
    }

    public static PsiClass getTopLevelParentClass(PsiClass psiClass) {
        return (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
    }

    @Nullable
    public static String getClassVMName(@Nullable PsiClass containingClass) {
        if (containingClass == null || PsiUtil.isLocalClass((PsiClass)containingClass)) {
            return null;
        }
        if (containingClass instanceof PsiAnonymousClass) {
            String parentName = JVMNameUtil.getClassVMName((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class));
            if (parentName == null) {
                return null;
            }
            return parentName + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)containingClass));
        }
        return ClassUtil.getJVMClassName((PsiClass)containingClass);
    }

    private static class JVMClassAt
    implements JVMName {
        private final SourcePosition mySourcePosition;

        public JVMClassAt(SourcePosition sourcePosition) {
            this.mySourcePosition = sourcePosition;
        }

        @Override
        public String getName(DebugProcessImpl process2) throws EvaluateException {
            List<ReferenceType> allClasses = process2.getPositionManager().getAllClasses(this.mySourcePosition);
            if (allClasses.size() > 1) {
                String name = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return JVMNameUtil.getClassVMName(JVMNameUtil.getClassAt(mySourcePosition));
                    }
                });
                for (ReferenceType aClass : allClasses) {
                    if (!Comparing.equal((String)aClass.name(), (String)name)) continue;
                    return name;
                }
            }
            if (!allClasses.isEmpty()) {
                return allClasses.get(0).name();
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{this.getDisplayName(process2)}));
        }

        @Override
        public String getDisplayName(final DebugProcessImpl debugProcess) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, mySourcePosition);
                }
            });
        }
    }

    private static class JVMRawText
    implements JVMName {
        private String myText;

        public JVMRawText(String text) {
            this.myText = text;
        }

        @Override
        public String getName(DebugProcessImpl process2) throws EvaluateException {
            return this.myText;
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return this.myText;
        }

        public String getName() {
            return this.myText;
        }

        public void setName(String name) {
            this.myText = name;
        }

        public String toString() {
            return this.myText;
        }
    }

    private static class JVMNameBuffer {
        private final List<JVMName> myList = new ArrayList<JVMName>();

        private JVMNameBuffer() {
        }

        public void append(@NotNull JVMName evaluator) {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/debugger/engine/JVMNameUtil$JVMNameBuffer", "append"));
            }
            this.myList.add(evaluator);
        }

        public void append(char name) {
            this.append(Character.toString(name));
        }

        public void append(String text) {
            this.myList.add(JVMNameUtil.getJVMRawText(text));
        }

        public JVMName toName() {
            final ArrayList<JVMName> optimised = new ArrayList<JVMName>();
            for (JVMName evaluator : this.myList) {
                if (evaluator instanceof JVMRawText && !optimised.isEmpty() && optimised.get(optimised.size() - 1) instanceof JVMRawText) {
                    JVMRawText nameEvaluator = (JVMRawText)optimised.get(optimised.size() - 1);
                    nameEvaluator.setName(nameEvaluator.getName() + ((JVMRawText)evaluator).getName());
                    continue;
                }
                optimised.add(evaluator);
            }
            if (optimised.size() == 1) {
                return (JVMName)optimised.get(0);
            }
            if (optimised.isEmpty()) {
                return new JVMRawText("");
            }
            return new JVMName(){
                String myName = null;

                @Override
                public String getName(DebugProcessImpl process2) throws EvaluateException {
                    if (this.myName == null) {
                        String name = "";
                        for (JVMName nameEvaluator : optimised) {
                            name = name + nameEvaluator.getName(process2);
                        }
                        this.myName = name;
                    }
                    return this.myName;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    if (this.myName == null) {
                        String displayName = "";
                        for (JVMName nameEvaluator : optimised) {
                            displayName = displayName + nameEvaluator.getDisplayName(debugProcess);
                        }
                        return displayName;
                    }
                    return this.myName;
                }
            };
        }
    }
}

