/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import org.jetbrains.annotations.NotNull;

class FrameworkTypeNode
extends DetectedFrameworkTreeNodeBase {
    private final FrameworkType myFrameworkType;

    public FrameworkTypeNode(@NotNull FrameworkType frameworkType) {
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "com/intellij/framework/detection/impl/ui/FrameworkTypeNode", "<init>"));
        }
        super(frameworkType);
        this.myFrameworkType = frameworkType;
    }

    @Override
    public void renderNode(ColoredTreeCellRenderer renderer) {
        renderer.setIcon(this.myFrameworkType.getIcon());
        renderer.append(this.myFrameworkType.getPresentableName());
    }

    @Override
    public String getCheckedDescription() {
        return null;
    }

    @Override
    public String getUncheckedDescription() {
        return "'" + this.myFrameworkType.getPresentableName() + "' framework detection will be disabled.";
    }

    @Override
    public void disableDetection(DetectionExcludesConfiguration configuration) {
        configuration.addExcludedFramework(this.myFrameworkType);
    }
}

