/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalHistoryAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "update"));
        }
        Presentation p = e.getPresentation();
        if (e.getProject() == null) {
            p.setEnabledAndVisible(false);
        } else {
            p.setVisible(true);
            p.setText(this.getText(e), true);
            LocalHistoryFacade vcs = this.getVcs();
            IdeaGateway gateway = this.getGateway();
            p.setEnabled(vcs != null && gateway != null && this.isEnabled(vcs, gateway, e));
        }
    }

    protected String getText(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "getText"));
        }
        return e.getPresentation().getTextWithMnemonic();
    }

    protected boolean isEnabled(@NotNull LocalHistoryFacade vcs, @NotNull IdeaGateway gw, @NotNull AnActionEvent e) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "isEnabled"));
        }
        if (gw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gw", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "isEnabled"));
        }
        return this.isEnabled(vcs, gw, this.getFile(e), e);
    }

    protected boolean isEnabled(@NotNull LocalHistoryFacade vcs, @NotNull IdeaGateway gw, @Nullable VirtualFile f, @NotNull AnActionEvent e) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "isEnabled"));
        }
        if (gw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gw", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "isEnabled"));
        }
        return true;
    }

    @Nullable
    protected LocalHistoryFacade getVcs() {
        return LocalHistoryImpl.getInstanceImpl().getFacade();
    }

    @Nullable
    protected IdeaGateway getGateway() {
        return LocalHistoryImpl.getInstanceImpl().getGateway();
    }

    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/actions/LocalHistoryAction", "getFile"));
        }
        return (VirtualFile)VcsUtil.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
    }
}

