/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.io.URLUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyUrlAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CopyUrlAction", "actionPerformed"));
        }
        String url = CopyUrlAction.findUrlAtCaret(e);
        assert (url != null);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(url));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CopyUrlAction", "update"));
        }
        e.getPresentation().setEnabledAndVisible(CopyUrlAction.findUrlAtCaret(e) != null);
    }

    @Nullable
    private static String findUrlAtCaret(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CopyUrlAction", "findUrlAtCaret"));
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        String url = CopyUrlAction.findUrl(editor, offset);
        if (url != null) {
            return url;
        }
        int expectedCaretOffset = ((EditorEx)editor).getExpectedCaretOffset();
        return expectedCaretOffset == offset ? null : CopyUrlAction.findUrl(editor, expectedCaretOffset);
    }

    private static String findUrl(Editor editor, int offset) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        while (offset > 0 && CopyUrlAction.seemsUrlPart(chars.charAt(offset - 1))) {
            --offset;
        }
        Matcher matcher = URLUtil.URL_PATTERN.matcher(chars.subSequence(offset, chars.length()));
        if (matcher.lookingAt()) {
            return matcher.group();
        }
        return null;
    }

    private static boolean seemsUrlPart(char c) {
        return !Character.isWhitespace(c) && c != '(' && c != '[' && c != '<' && c != '{' && c != ',';
    }
}

