/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.TodoItem;
import com.intellij.ui.HighlightedRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class TodoItemNode
extends BaseToDoNode<SmartTodoItemPointer>
implements HighlightedRegionProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.toDo.TodoItemNodeDescriptor");
    private final ArrayList<HighlightedRegion> myHighlightedRegions;

    public TodoItemNode(Project project2, SmartTodoItemPointer value, TodoTreeBuilder builder) {
        super(project2, value, builder);
        RangeMarker rangeMarker = ((SmartTodoItemPointer)this.getValue()).getRangeMarker();
        LOG.assertTrue(rangeMarker.isValid());
        this.myHighlightedRegions = new ArrayList();
    }

    @Override
    public int getFileCount(SmartTodoItemPointer val) {
        return 1;
    }

    @Override
    public int getTodoItemCount(SmartTodoItemPointer val) {
        return 1;
    }

    public ArrayList<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        List<AbstractTreeNode> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/nodes/TodoItemNode", "getChildren"));
        }
        return list;
    }

    public void update(PresentationData presentation) {
        int lineStartOffset;
        TodoItem todoItem = ((SmartTodoItemPointer)this.getValue()).getTodoItem();
        RangeMarker myRangeMarker = ((SmartTodoItemPointer)this.getValue()).getRangeMarker();
        if (!todoItem.getFile().isValid() || !myRangeMarker.isValid() || myRangeMarker.getStartOffset() == myRangeMarker.getEndOffset()) {
            myRangeMarker.dispose();
            this.setValue(null);
            return;
        }
        this.myHighlightedRegions.clear();
        Document document2 = ((SmartTodoItemPointer)this.getValue()).getDocument();
        CharSequence chars = document2.getCharsSequence();
        int startOffset = myRangeMarker.getStartOffset();
        int endOffset = myRangeMarker.getEndOffset();
        LOG.assertTrue(startOffset > -1);
        LOG.assertTrue(startOffset <= document2.getTextLength());
        LOG.assertTrue(endOffset > -1);
        LOG.assertTrue(endOffset < document2.getTextLength() + 1);
        int lineNumber = document2.getLineNumber(startOffset);
        LOG.assertTrue(lineNumber > -1);
        LOG.assertTrue(lineNumber < document2.getLineCount());
        LOG.assertTrue(lineStartOffset > -1);
        LOG.assertTrue(lineStartOffset <= startOffset);
        LOG.assertTrue(lineStartOffset <= document2.getTextLength());
        int columnNumber = startOffset - lineStartOffset;
        LOG.assertTrue(columnNumber > -1);
        for (lineStartOffset = document2.getLineStartOffset(lineNumber); lineStartOffset < document2.getTextLength() && (chars.charAt(lineStartOffset) == '\t' || chars.charAt(lineStartOffset) == ' '); ++lineStartOffset) {
        }
        int lineEndOffset = document2.getLineEndOffset(lineNumber);
        LOG.assertTrue(lineEndOffset >= 0);
        LOG.assertTrue(lineEndOffset <= document2.getTextLength());
        String lineColumnPrefix = "(" + (lineNumber + 1) + ", " + (columnNumber + 1) + ") ";
        String highlightedText = chars.subSequence(lineStartOffset, Math.min(lineEndOffset, chars.length())).toString();
        String newName = lineColumnPrefix + highlightedText;
        Icon newIcon = todoItem.getPattern().getAttributes().getIcon();
        this.myHighlightedRegions.clear();
        EditorHighlighter highlighter = this.myBuilder.getHighlighter(todoItem.getFile(), document2);
        HighlighterIterator iterator = highlighter.createIterator(lineStartOffset);
        while (!iterator.atEnd()) {
            int start = Math.max(iterator.getStart(), lineStartOffset);
            int end = Math.min(iterator.getEnd(), lineEndOffset);
            if (lineEndOffset < start || lineEndOffset < end) break;
            TextAttributes attributes = iterator.getTextAttributes();
            int fontType = attributes.getFontType();
            if ((fontType & 1) != 0) {
                attributes = attributes.clone();
                attributes.setFontType(fontType & 0xFFFFFFFE);
            }
            HighlightedRegion region = new HighlightedRegion(lineColumnPrefix.length() + start - lineStartOffset, lineColumnPrefix.length() + end - lineStartOffset, attributes);
            this.myHighlightedRegions.add(region);
            iterator.advance();
        }
        TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
        HighlightedRegion region = new HighlightedRegion(lineColumnPrefix.length() + startOffset - lineStartOffset, lineColumnPrefix.length() + endOffset - lineStartOffset, attributes);
        this.myHighlightedRegions.add(region);
        presentation.setPresentableText(newName);
        presentation.setIcon(newIcon);
    }

    public String getTestPresentation() {
        return "Item: " + ((SmartTodoItemPointer)this.getValue()).getTodoItem().getTextRange();
    }

    public int getWeight() {
        return 5;
    }
}

