/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.validation;

import com.intellij.internal.validation.ValidTest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class ValidationTest
extends DialogWrapper {
    private ValidTest myPanel = new ValidTest();
    final ValidationInfo[] ERRORS;

    protected ValidationTest(Project project2) {
        super(project2);
        this.ERRORS = new ValidationInfo[]{new ValidationInfo("Field1 should not be empty", (JComponent)this.myPanel.field1), new ValidationInfo("Field2 is zip. It should contain 5 digits", (JComponent)this.myPanel.field2), new ValidationInfo("Field3. Value is not chosen", (JComponent)this.myPanel.field3), new ValidationInfo("Field4: Select A or B", (JComponent)this.myPanel.p4), new ValidationInfo("Field5: You should accept license agreement<br/>text text text text text text text text text text text text<br/>text text text text text text text text text text text text")};
        this.init();
    }

    protected boolean postponeValidation() {
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.field2;
    }

    protected void doOKAction() {
        super.doOKAction();
        Messages.showInfoMessage((String)"on OK", (String)"Info");
    }

    protected ValidationInfo doValidate() {
        if (this.myPanel.field1.getText().isEmpty()) {
            return this.ERRORS[0];
        }
        if (!Pattern.compile("[0-9]{5}").matcher(this.myPanel.field2.getText()).matches()) {
            return this.ERRORS[1];
        }
        if (this.myPanel.field3.getSelectedItem() == null || "".equals(this.myPanel.field3.getSelectedItem())) {
            return this.ERRORS[2];
        }
        if (!this.myPanel.field4A.isSelected() && !this.myPanel.field4B.isSelected()) {
            return this.ERRORS[3];
        }
        if (!this.myPanel.field5.isSelected()) {
            return this.ERRORS[4];
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.panel;
    }
}

