/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffRangeMarker
implements RangeMarker {
    private final RangeMarker myRangeMarker;

    DiffRangeMarker(@NotNull Document document2, @NotNull TextRange range, RangeInvalidListener listener2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "<init>"));
        }
        this.myRangeMarker = document2.createRangeMarker(range.getStartOffset(), range.getEndOffset());
        if (listener2 != null) {
            InvalidRangeDispatcher.addClient(document2, this, listener2);
        }
    }

    public void removeListener(@NotNull RangeInvalidListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "removeListener"));
        }
        InvalidRangeDispatcher.removeClient(this.getDocument(), this, listener2);
    }

    @NotNull
    public Document getDocument() {
        Document document2 = this.myRangeMarker.getDocument();
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "getDocument"));
        }
        return document2;
    }

    public int getStartOffset() {
        return this.myRangeMarker.getStartOffset();
    }

    public int getEndOffset() {
        return this.myRangeMarker.getEndOffset();
    }

    public boolean isValid() {
        return this.myRangeMarker.isValid();
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myRangeMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myRangeMarker.setGreedyToRight(greedy);
    }

    public boolean isGreedyToRight() {
        return this.myRangeMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myRangeMarker.isGreedyToLeft();
    }

    public void dispose() {
        this.myRangeMarker.dispose();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "getUserData"));
        }
        return (T)this.myRangeMarker.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "putUserData"));
        }
        this.myRangeMarker.putUserData(key2, value);
    }

    private static class InvalidRangeDispatcher
    extends DocumentAdapter {
        private static final Key<InvalidRangeDispatcher> KEY = Key.create((String)"deferedNotifier");
        private final Map<DiffRangeMarker, RangeInvalidListener> myDiffRangeMarkers = ContainerUtil.newConcurrentMap();

        private InvalidRangeDispatcher() {
        }

        public void documentChanged(DocumentEvent e) {
            Iterator<Map.Entry<DiffRangeMarker, RangeInvalidListener>> iterator = this.myDiffRangeMarkers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DiffRangeMarker, RangeInvalidListener> entry = iterator.next();
                DiffRangeMarker diffRangeMarker = entry.getKey();
                RangeInvalidListener listener2 = entry.getValue();
                if (diffRangeMarker.isValid() || listener2 == null) continue;
                listener2.onRangeInvalidated();
                iterator.remove();
            }
        }

        private static void addClient(@NotNull Document document2, @NotNull DiffRangeMarker marker, @NotNull RangeInvalidListener listener2) {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "addClient"));
            }
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "addClient"));
            }
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "addClient"));
            }
            InvalidRangeDispatcher notifier = (InvalidRangeDispatcher)((Object)document2.getUserData(KEY));
            if (notifier == null) {
                notifier = new InvalidRangeDispatcher();
                document2.putUserData(KEY, (Object)notifier);
                document2.addDocumentListener((DocumentListener)notifier);
            }
            assert (!notifier.myDiffRangeMarkers.containsKey(marker));
            notifier.myDiffRangeMarkers.put(marker, listener2);
        }

        private static void removeClient(@NotNull Document document2, @NotNull DiffRangeMarker marker, @NotNull RangeInvalidListener listener2) {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "removeClient"));
            }
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "removeClient"));
            }
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "removeClient"));
            }
            InvalidRangeDispatcher notifier = (InvalidRangeDispatcher)((Object)document2.getUserData(KEY));
            assert (notifier != null);
            notifier.onClientRemoved(document2, marker, listener2);
        }

        private void onClientRemoved(@NotNull Document document2, @NotNull DiffRangeMarker marker, @NotNull RangeInvalidListener listener2) {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "onClientRemoved"));
            }
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "onClientRemoved"));
            }
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "onClientRemoved"));
            }
            if (this.myDiffRangeMarkers.remove(marker) == listener2 && this.myDiffRangeMarkers.isEmpty()) {
                document2.putUserData(KEY, null);
                document2.removeDocumentListener((DocumentListener)this);
            }
        }
    }

    static interface RangeInvalidListener {
        public void onRangeInvalidated();
    }
}

