/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SplitLineAction
extends EditorAction {
    public static Key<Boolean> SPLIT_LINE_KEY = Key.create((String)"com.intellij.openapi.editor.actions.SplitLineAction");

    public SplitLineAction() {
        super((EditorActionHandler)new Handler());
        this.setEnabledInModalContext(false);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/SplitLineAction$Handler", "isEnabledForCaret"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actions/SplitLineAction$Handler", "isEnabledForCaret"));
            }
            return Handler.getEnterHandler().isEnabled(editor, caret, dataContext) && !((EditorEx)editor).isEmbeddedIntoDialogWrapper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            CopyPasteManager.getInstance().stopKillRings();
            Document document2 = editor.getDocument();
            RangeMarker rangeMarker = document2.createRangeMarker(editor.getCaretModel().getOffset(), editor.getCaretModel().getOffset());
            CharSequence chars = document2.getCharsSequence();
            int offset = editor.getCaretModel().getOffset();
            int lineStart = document2.getLineStartOffset(document2.getLineNumber(offset));
            CharSequence beforeCaret = chars.subSequence(lineStart, offset);
            if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)beforeCaret)) {
                String strToInsert = "";
                if (beforeCaret != null) {
                    strToInsert = strToInsert + beforeCaret.toString();
                }
                strToInsert = strToInsert + "\n";
                document2.insertString(lineStart, (CharSequence)strToInsert);
                editor.getCaretModel().moveToOffset(offset);
            } else {
                DataManager.getInstance().saveInDataContext(dataContext, SPLIT_LINE_KEY, (Object)true);
                try {
                    Handler.getEnterHandler().execute(editor, caret, dataContext);
                }
                finally {
                    DataManager.getInstance().saveInDataContext(dataContext, SPLIT_LINE_KEY, null);
                }
                editor.getCaretModel().moveToOffset(Math.min(document2.getTextLength(), rangeMarker.getStartOffset()));
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static EditorActionHandler getEnterHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorEnter");
        }
    }
}

