/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNodeAction<T>
extends ExternalSystemAction {
    private final Class<T> myExternalDataClazz;

    public ExternalSystemNodeAction(Class<T> externalDataClazz) {
        this.myExternalDataClazz = externalDataClazz;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && this.getSystemId(e) != null && this.getExternalData(e, this.myExternalDataClazz) != null;
    }

    protected abstract void perform(@NotNull Project var1, @NotNull ProjectSystemId var2, @NotNull T var3, @NotNull AnActionEvent var4);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/ExternalSystemNodeAction", "actionPerformed"));
        }
        Project project2 = this.getProject(e);
        if (project2 == null) {
            return;
        }
        ProjectSystemId projectSystemId = this.getSystemId(e);
        if (projectSystemId == null) {
            return;
        }
        T data = this.getExternalData(e, this.myExternalDataClazz);
        if (data == null) {
            return;
        }
        this.perform(project2, projectSystemId, data, e);
    }

    @Nullable
    protected ExternalSystemUiAware getExternalSystemUiAware(AnActionEvent e) {
        return (ExternalSystemUiAware)ExternalSystemDataKeys.UI_AWARE.getData(e.getDataContext());
    }

    @Nullable
    protected <T> T getExternalData(AnActionEvent e, Class<T> dataClass) {
        ExternalSystemNode node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext())));
        return node != null && dataClass.isInstance(node.getData()) ? (T)node.getData() : null;
    }

    protected boolean isIgnoredNode(AnActionEvent e) {
        ExternalSystemNode node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext())));
        return node != null && this.myExternalDataClazz.isInstance(node.getData()) && node.isIgnored();
    }

    @Nullable
    protected VirtualFile getExternalConfig(@NotNull ExternalConfigPathAware data, ProjectSystemId externalSystemId) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/action/ExternalSystemNodeAction", "getExternalConfig"));
        }
        String path = data.getLinkedExternalProjectPath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile externalSystemConfigPath = fileSystem.refreshAndFindFileByPath(path);
        if (externalSystemConfigPath == null) {
            return null;
        }
        VirtualFile toOpen = externalSystemConfigPath;
        for (ExternalSystemConfigLocator locator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals((Object)locator.getTargetExternalSystemId())) continue;
            if ((toOpen = locator.adjust(toOpen)) != null) break;
            return null;
        }
        return toOpen.isDirectory() ? null : toOpen;
    }
}

