/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.execution.rmi.RemoteObject;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.util.containers.ContainerUtil;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemProgressNotificationManagerImpl
extends RemoteObject
implements ExternalSystemProgressNotificationManager,
RemoteExternalSystemProgressNotificationManager {
    private final ConcurrentMap<ExternalSystemTaskNotificationListener, Set<ExternalSystemTaskId>> myListeners = ContainerUtil.newConcurrentMap();

    @Override
    public boolean addNotificationListener(@NotNull ExternalSystemTaskNotificationListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "addNotificationListener"));
        }
        Set dummy = Collections.emptySet();
        return this.myListeners.put(listener2, dummy) == null;
    }

    @Override
    public boolean addNotificationListener(@NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "addNotificationListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "addNotificationListener"));
        }
        Set<ExternalSystemTaskId> ids = null;
        while (ids == null) {
            if (this.myListeners.containsKey(listener2)) {
                ids = (Set)this.myListeners.get(listener2);
                continue;
            }
            ids = this.myListeners.putIfAbsent(listener2, ContainerUtil.newConcurrentSet());
        }
        return ids.add(taskId);
    }

    @Override
    public boolean removeNotificationListener(@NotNull ExternalSystemTaskNotificationListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "removeNotificationListener"));
        }
        return this.myListeners.remove(listener2) != null;
    }

    @Override
    public void onQueued(@NotNull ExternalSystemTaskId id, @NotNull String workingDir) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onQueued"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onQueued"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onQueued(id, workingDir);
        }
    }

    @Override
    public void onStart(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onStart"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onStart(id);
        }
    }

    @Override
    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onStatusChange"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(event.getId())) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onStatusChange(event);
        }
    }

    @Override
    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onTaskOutput"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onTaskOutput"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onTaskOutput(id, text, stdOut);
        }
    }

    @Override
    public void onEnd(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onEnd"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onEnd(id);
        }
    }

    @Override
    public void onSuccess(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onSuccess"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onSuccess(id);
        }
    }

    @Override
    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onFailure"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "onFailure"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onFailure(id, e);
        }
    }

    @Override
    public void beforeCancel(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl", "beforeCancel"));
        }
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).beforeCancel(id);
        }
    }

    @Override
    public void onCancel(ExternalSystemTaskId id) throws RemoteException {
        for (Map.Entry entry : this.myListeners.entrySet()) {
            Set ids = (Set)entry.getValue();
            if (Collections.EMPTY_SET != ids && !ids.contains(id)) continue;
            ((ExternalSystemTaskNotificationListener)entry.getKey()).onCancel(id);
        }
    }
}

