/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.InvalidDataException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OrderEntryFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderEntryFactory");
    @NonNls
    public static final String ORDER_ENTRY_ELEMENT_NAME = "orderEntry";
    @NonNls
    public static final String ORDER_ENTRY_TYPE_ATTR = "type";

    @NotNull
    static OrderEntry createOrderEntryByElement(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
        }
        LOG.assertTrue(ORDER_ENTRY_ELEMENT_NAME.equals(element.getName()));
        String type = element.getAttributeValue(ORDER_ENTRY_TYPE_ATTR);
        if (type == null) {
            throw new InvalidDataException();
        }
        if ("sourceFolder".equals(type)) {
            ModuleSourceOrderEntryImpl moduleSourceOrderEntryImpl = new ModuleSourceOrderEntryImpl(element, rootModel);
            if (moduleSourceOrderEntryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
            }
            return moduleSourceOrderEntryImpl;
        }
        if ("jdk".equals(type)) {
            ModuleJdkOrderEntryImpl moduleJdkOrderEntryImpl = new ModuleJdkOrderEntryImpl(element, rootModel, projectRootManager);
            if (moduleJdkOrderEntryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
            }
            return moduleJdkOrderEntryImpl;
        }
        if ("inheritedJdk".equals(type)) {
            InheritedJdkOrderEntryImpl inheritedJdkOrderEntryImpl = new InheritedJdkOrderEntryImpl(element, rootModel, projectRootManager);
            if (inheritedJdkOrderEntryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
            }
            return inheritedJdkOrderEntryImpl;
        }
        if ("library".equals(type)) {
            LibraryOrderEntryImpl libraryOrderEntryImpl = new LibraryOrderEntryImpl(element, rootModel, projectRootManager);
            if (libraryOrderEntryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
            }
            return libraryOrderEntryImpl;
        }
        if ("module-library".equals(type)) {
            ModuleLibraryOrderEntryImpl moduleLibraryOrderEntryImpl = new ModuleLibraryOrderEntryImpl(element, rootModel, projectRootManager);
            if (moduleLibraryOrderEntryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
            }
            return moduleLibraryOrderEntryImpl;
        }
        if ("module".equals(type)) {
            ModuleOrderEntryImpl moduleOrderEntryImpl = new ModuleOrderEntryImpl(element, rootModel);
            if (moduleOrderEntryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryByElement"));
            }
            return moduleOrderEntryImpl;
        }
        throw new InvalidDataException("Unknown order entry type:" + type);
    }

    @NotNull
    static Element createOrderEntryElement(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ORDER_ENTRY_TYPE_ATTR, "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryElement"));
        }
        Element element = new Element(ORDER_ENTRY_ELEMENT_NAME);
        element.setAttribute(ORDER_ENTRY_TYPE_ATTR, type);
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryFactory", "createOrderEntryElement"));
        }
        return element2;
    }
}

