/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedDiffRequestPresentable
implements DiffRequestPresentable {
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myAfterTitle;
    private final Getter<ApplyPatchForBaseRevisionTexts> myTexts;

    public MergedDiffRequestPresentable(Project project2, Getter<ApplyPatchForBaseRevisionTexts> texts, VirtualFile file2, String afterTitle) {
        this.myTexts = texts;
        this.myProject = project2;
        this.myFile = file2;
        this.myAfterTitle = afterTitle;
    }

    public DiffRequestPresentable.MyResult step(DiffChainContext context) {
        boolean nowItIsText;
        if (this.myFile.getFileType().isBinary() && !(nowItIsText = ChangeDiffRequestPresentable.checkAssociate(this.myProject, this.myFile.getName(), context))) {
            SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
            return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.removeFromList);
        }
        ApplyPatchForBaseRevisionTexts revisionTexts = (ApplyPatchForBaseRevisionTexts)this.myTexts.get();
        if (revisionTexts.getBase() == null) {
            SimpleDiffRequest badDiffRequest = MergedDiffRequestPresentable.createBadDiffRequest(this.myProject, this.myFile, revisionTexts, true);
            return new DiffRequestPresentable.MyResult((DiffRequest)badDiffRequest, DiffPresentationReturnValue.useRequest);
        }
        MergeRequest request = DiffRequestFactory.getInstance().create3WayDiffRequest(revisionTexts.getLocal().toString(), revisionTexts.getPatched(), revisionTexts.getBase().toString(), this.myFile.getFileType(), this.myProject, null, null);
        request.setWindowTitle(VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{FileUtil.toSystemDependentName((String)this.myFile.getPresentableUrl())}));
        request.setVersionTitles(new String[]{"Current Version", "Base Version", FileUtil.toSystemDependentName((String)this.myAfterTitle)});
        return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.useRequest);
    }

    public String getPathPresentation() {
        return this.myFile.getPath();
    }

    public void haveStuff() {
    }

    public List<? extends AnAction> createActions(DiffExtendUIFactory uiFactory) {
        return Collections.emptyList();
    }

    @NotNull
    public static SimpleDiffRequest createBadDiffRequest(final @Nullable Project project2, final @NotNull VirtualFile file2, @NotNull ApplyPatchForBaseRevisionTexts texts, boolean readonly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/MergedDiffRequestPresentable", "createBadDiffRequest"));
        }
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/openapi/vcs/changes/patch/MergedDiffRequestPresentable", "createBadDiffRequest"));
        }
        String fullPath = file2.getParent() == null ? file2.getPath() : file2.getParent().getPath();
        String title = "Result Of Patch Apply To " + file2.getName() + " (" + fullPath + ")";
        SimpleDiffRequest simpleRequest = new SimpleDiffRequest(project2, title);
        DocumentImpl patched = new DocumentImpl(texts.getPatched());
        patched.setReadOnly(false);
        final DocumentContent mergedContent = new DocumentContent(project2, (Document)patched, file2.getFileType());
        mergedContent.getDocument().setReadOnly(readonly);
        SimpleContent originalContent = new SimpleContent(texts.getLocal().toString(), file2.getFileType());
        simpleRequest.setContents((DiffContent)originalContent, (DiffContent)mergedContent);
        simpleRequest.setContentTitles(VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]), "Patched (with problems)");
        simpleRequest.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
        simpleRequest.addHint(DiffTool.HINT_DIFF_IS_APPROXIMATE);
        if (!readonly) {
            simpleRequest.setOnOkRunnable(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            String resultText = mergedContent.getDocument().getText();
                            Document document2 = FileDocumentManager.getInstance().getDocument(file2);
                            if (document2 == null) {
                                try {
                                    VfsUtil.saveText((VirtualFile)file2, (String)resultText);
                                }
                                catch (IOException e) {
                                    MergedDiffRequestPresentable.showIOException(project2, file2.getName(), e);
                                }
                            } else {
                                document2.setText((CharSequence)resultText);
                                FileDocumentManager.getInstance().saveDocument(document2);
                            }
                        }
                    });
                }
            });
        }
        SimpleDiffRequest simpleDiffRequest = simpleRequest;
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/MergedDiffRequestPresentable", "createBadDiffRequest"));
        }
        return simpleDiffRequest;
    }

    private static void showIOException(@Nullable Project project2, @NotNull String name, @NotNull IOException e) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/patch/MergedDiffRequestPresentable", "showIOException"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/MergedDiffRequestPresentable", "showIOException"));
        }
        Messages.showErrorDialog((Project)project2, (String)VcsBundle.message((String)"patch.apply.error", (Object[])new Object[]{name, e.getMessage()}), (String)VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
    }
}

