/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentComboLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class ComboContentLayout
extends ContentLayout {
    ContentComboLabel myComboLabel;

    ComboContentLayout(ToolWindowContentUi ui) {
        super(ui);
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false);
        this.myComboLabel = new ContentComboLabel(this);
    }

    @Override
    public void reset() {
        this.myIdLabel = null;
        this.myComboLabel = null;
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        JBDimension idSize = this.isIdVisible() ? this.myIdLabel.getPreferredSize() : JBUI.emptySize();
        int eachX = 0;
        int eachY = 0;
        this.myIdLabel.setBounds(eachX, eachY, idSize.width, bounds.height);
        Dimension comboSize = this.myComboLabel.getPreferredSize();
        int spaceLeft = bounds.width - (eachX += idSize.width) - (this.isToDrawCombo() && this.isIdVisible() ? 3 : 0);
        int width = comboSize.width;
        if (width > spaceLeft) {
            width = spaceLeft;
        }
        this.myComboLabel.setBounds(eachX, eachY, width, bounds.height);
    }

    @Override
    public int getMinimumWidth() {
        return this.myIdLabel != null ? this.myIdLabel.getPreferredSize().width : 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawCombo()) {
            return;
        }
        Rectangle r = this.myComboLabel.getBounds();
        g.setColor(ColorUtil.toAlpha((Color)UIUtil.getLabelForeground(), (int)20));
        g.drawLine(r.width, 0, r.width, r.height);
        g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
        g.drawLine(r.width - 1, 0, r.width - 1, r.height);
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    @Override
    public void update() {
        this.updateIdLabel(this.myIdLabel);
        this.myComboLabel.update();
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi);
        this.myUi.add(this.myComboLabel);
        ToolWindowContentUi.initMouseListeners(this.myComboLabel, this.myUi);
    }

    boolean isToDrawCombo() {
        return this.myUi.myManager.getContentCount() > 1;
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
    }

    @Override
    public boolean shouldDrawDecorations() {
        return this.isToDrawCombo();
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        int width = this.myComboLabel.getSize().width;
        listPopup.setMinimumSize(new Dimension(width, 0));
        listPopup.show(new RelativePoint((Component)this.myComboLabel, new Point(-2, this.myComboLabel.getHeight())));
    }

    @Override
    public RelativeRectangle getRectangleFor(Content content) {
        return null;
    }

    @Override
    public Component getComponentFor(Content content) {
        return null;
    }

    @Override
    public String getCloseActionName() {
        return "Close View";
    }

    @Override
    public String getCloseAllButThisActionName() {
        return "Close Other Views";
    }

    @Override
    public String getPreviousContentActionName() {
        return "Select Previous View";
    }

    @Override
    public String getNextContentActionName() {
        return "Select Next View";
    }
}

