/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaSourceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaSourceUtil");
    private static final TokenSet REF_FILTER = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.ANNOTATION})});

    private JavaSourceUtil() {
    }

    public static void fullyQualifyReference(@NotNull CompositeElement reference, @NotNull PsiClass targetClass) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "fullyQualifyReference"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "fullyQualifyReference"));
        }
        if (((SourceJavaCodeReference)((Object)reference)).isQualified()) {
            PsiClass parentClass = targetClass.getContainingClass();
            if (parentClass == null) {
                return;
            }
            ASTNode qualifier = reference.findChildByRole(54);
            if (qualifier instanceof SourceJavaCodeReference) {
                ((SourceJavaCodeReference)qualifier).fullyQualify(parentClass);
            }
        } else {
            String qName = targetClass.getQualifiedName();
            if (qName == null) {
                return;
            }
            int i = qName.lastIndexOf(46);
            if (i > 0) {
                String prefix = qName.substring(0, i);
                PsiManagerEx manager = reference.getManager();
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)manager.getProject()).getParserFacade();
                TreeElement qualifier = reference instanceof PsiReferenceExpression ? (TreeElement)parserFacade.createExpressionFromText(prefix, null).getNode() : (TreeElement)parserFacade.createReferenceFromText(prefix, null).getNode();
                if (qualifier != null) {
                    CharTable systemCharTab = SharedImplUtil.findCharTableByTree(qualifier);
                    LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, systemCharTab, manager);
                    qualifier.rawInsertAfterMe(dot);
                    reference.addInternal(qualifier, dot, null, Boolean.FALSE);
                }
            }
        }
    }

    @NotNull
    public static String getReferenceText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "getReferenceText"));
        }
        final StringBuilder buffer = new StringBuilder();
        ((TreeElement)ref.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                if (!REF_FILTER.contains(leaf.getElementType())) {
                    char lastInBuffer;
                    String leafText = leaf.getText();
                    if (buffer.length() > 0 && !leafText.isEmpty() && Character.isJavaIdentifierPart(leafText.charAt(0)) && ((lastInBuffer = buffer.charAt(buffer.length() - 1)) == '?' || Character.isJavaIdentifierPart(lastInBuffer))) {
                        buffer.append(" ");
                    }
                    buffer.append(leafText);
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (!REF_FILTER.contains(composite.getElementType())) {
                    super.visitComposite(composite);
                }
            }
        });
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "getReferenceText"));
        }
        return string;
    }

    @NotNull
    public static String getReferenceText(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "getReferenceText"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "getReferenceText"));
        }
        String string = LightTreeUtil.toFilteredString(tree, node, REF_FILTER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "getReferenceText"));
        }
        return string;
    }

    public static TreeElement addParenthToReplacedChild(@NotNull IElementType parenthType, @NotNull TreeElement newChild, @NotNull PsiManager manager) {
        if (parenthType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parenthType", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "addParenthToReplacedChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "addParenthToReplacedChild"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "addParenthToReplacedChild"));
        }
        CompositeElement parenthExpr = ASTFactory.composite(parenthType);
        TreeElement dummyExpr = (TreeElement)newChild.clone();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(newChild);
        new DummyHolder(manager, parenthExpr, null, charTableByTree);
        parenthExpr.putUserData(CharTable.CHAR_TABLE_KEY, charTableByTree);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.LPARENTH, "("));
        parenthExpr.rawAddChildren(dummyExpr);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.RPARENTH, ")"));
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            PsiElement formatted = codeStyleManager.reformat(SourceTreeToPsiMap.treeToPsiNotNull(parenthExpr));
            parenthExpr = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(formatted);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        newChild.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(newChild));
        dummyExpr.getTreeParent().replaceChild(dummyExpr, newChild);
        TreeUtil.clearCaches(TreeUtil.getFileElement(parenthExpr));
        return parenthExpr;
    }

    public static void deleteSeparatingComma(@NotNull CompositeElement element, @NotNull ASTNode child) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "deleteSeparatingComma"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "deleteSeparatingComma"));
        }
        assert (child.getElementType() != JavaTokenType.COMMA) : child;
        ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
        if (next != null && next.getElementType() == JavaTokenType.COMMA) {
            element.deleteChildInternal(next);
        } else {
            ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
            if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
                element.deleteChildInternal(prev);
            }
        }
    }

    public static void addSeparatingComma(@NotNull CompositeElement element, @NotNull ASTNode child, @NotNull TokenSet listTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "addSeparatingComma"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "addSeparatingComma"));
        }
        if (listTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listTypes", "com/intellij/psi/impl/source/tree/JavaSourceUtil", "addSeparatingComma"));
        }
        assert (child.getElementType() != JavaTokenType.COMMA) : child;
        JavaSourceUtil.scanChildren(element, child, listTypes, true);
        JavaSourceUtil.scanChildren(element, child, listTypes, false);
    }

    private static void scanChildren(CompositeElement element, ASTNode node, TokenSet listTypes, boolean forward) {
        block1: {
            ASTNode child = node;
            do {
                ASTNode aSTNode = child = forward ? child.getTreeNext() : child.getTreePrev();
                if (child == null || child.getElementType() == JavaTokenType.COMMA) break block1;
            } while (!listTypes.contains(child.getElementType()));
            CharTable charTable = SharedImplUtil.findCharTableByTree(element);
            PsiManager manager = element.getPsi().getManager();
            LeafElement comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, charTable, manager);
            element.addInternal(comma, comma, forward ? node : child, Boolean.FALSE);
        }
    }
}

