/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.stubsHierarchy.impl.ClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.HierarchyService;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.PsiHierachyConnector;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;

public class PsiEnter {
    private final Symbols mySymbols;
    private final NameEnvironment myNameEnvironment;
    private final PsiHierachyConnector myPsiHierachyConnector;
    private ArrayList<Symbol.ClassSymbol> myQueue = new ArrayList();

    public PsiEnter(NameEnvironment nameEnvironment, Symbols symbols) {
        this.myNameEnvironment = nameEnvironment;
        this.mySymbols = symbols;
        this.myPsiHierachyConnector = new PsiHierachyConnector(nameEnvironment, symbols);
    }

    void enter(PsiClassOwner psiClassOwner) {
        ApplicationManager.getApplication().runReadAction(() -> this.enterTopLevels(psiClassOwner));
    }

    private void enterTopLevels(PsiClassOwner owner) {
        String pkgName = owner.getPackageName();
        Symbol.PackageSymbol pkg = StringUtil.isEmpty((String)pkgName) ? this.mySymbols.myRootPackage : this.mySymbols.enterPackage(this.myNameEnvironment.fromString(pkgName, true));
        for (PsiClass psiClass : owner.getClasses()) {
            this.enter(psiClass, (Symbol)pkg);
        }
    }

    private Symbol.ClassSymbol enter(PsiClass psiClass, Symbol owner) {
        if (HierarchyService.IGNORE_LOCAL_CLASSES && psiClass.getName() == null) {
            return null;
        }
        int psiFlags = PsiEnter.translateFlags(psiClass);
        int fileId = FileBasedIndex.getFileId((VirtualFile)psiClass.getContainingFile().getVirtualFile());
        ClassAnchor.DirectClassAnchor classAnchor = new ClassAnchor.DirectClassAnchor(fileId, psiClass);
        int shortName = this.myNameEnvironment.simpleName(psiClass.getName(), true);
        Symbol.ClassSymbol classSymbol = this.mySymbols.enterClass(classAnchor, psiFlags, shortName, owner, null, null, this.myPsiHierachyConnector);
        if (this.myQueue != null) {
            this.myQueue.add(classSymbol);
        }
        Symbol.ClassSymbol[] members = this.enter(psiClass.getInnerClasses(), (Symbol)classSymbol);
        classSymbol.setMembers(members);
        return classSymbol;
    }

    private Symbol.ClassSymbol[] enter(PsiClass[] psiClasses, Symbol owner) {
        Symbol.ClassSymbol[] members = new Symbol.ClassSymbol[psiClasses.length];
        int i = 0;
        for (PsiClass psiClass : psiClasses) {
            Symbol.ClassSymbol member = this.enter(psiClass, owner);
            if (member == null || member.myShortName == 0) continue;
            members[i++] = member;
        }
        members = members.length == 0 ? Symbol.ClassSymbol.EMPTY_ARRAY : Arrays.copyOf(members, i);
        Arrays.sort(members, Symbol.CLASS_SYMBOL_BY_NAME_COMPARATOR);
        return members;
    }

    public static int translateFlags(PsiClass psiClass) {
        int flags = 0;
        if (psiClass.isInterface()) {
            flags |= 0x10;
        }
        if (psiClass.isEnum()) {
            flags |= 0x40;
        }
        if (psiClass.isAnnotationType()) {
            flags |= 0x20;
        }
        if (psiClass.hasModifierProperty("static")) {
            flags |= 8;
        }
        return flags;
    }

    public void connect() {
        for (Symbol.ClassSymbol classSymbol : this.myQueue) {
            classSymbol.connect();
        }
        this.myQueue = null;
    }
}

