/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
implements FilePropertyPusher<Language> {
    public static final Key<Language> KEY = Key.create((String)"TEMPLATE_DATA_LANGUAGE");
    private static final VfsDependentEnum<String> ourLanguagesEnumerator = new VfsDependentEnum("languages", EnumeratorStringDescriptor.INSTANCE, 1);
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 2, true);

    public void initExtra(@NotNull Project project2, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "initExtra"));
        }
    }

    @NotNull
    public Key<Language> getFileDataKey() {
        Key<Language> key2 = KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "getFileDataKey"));
        }
        return key2;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public Language getDefaultValue() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "getDefaultValue"));
        }
        return language;
    }

    @Nullable
    public Language getImmediateValue(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "getImmediateValue"));
        }
        return (Language)TemplateDataLanguageMappings.getInstance(project2).getImmediateMapping(file2);
    }

    @Nullable
    public Language getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "getImmediateValue"));
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "acceptsFile"));
        }
        return true;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "acceptsDirectory"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "acceptsDirectory"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project2, @NotNull VirtualFile fileOrDir, @NotNull Language value) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "persistAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "persistAttribute"));
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLanguage = DataInputOutputUtil.readINT((DataInput)iStream);
                String oldLanguageId = ourLanguagesEnumerator.getById(oldLanguage);
                if (value.getID().equals(oldLanguageId)) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        if (value != Language.ANY || iStream != null) {
            DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)ourLanguagesEnumerator.getId(value.getID()));
            oStream.close();
            PushedFilePropertiesUpdater.getInstance((Project)project2).filePropertiesChanged(fileOrDir);
        }
    }

    public void afterRootsChanged(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher", "afterRootsChanged"));
        }
    }
}

