/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor");
    protected final PsiElement[] myElementsToMove;
    protected final boolean mySearchForReferences;
    protected final boolean mySearchInComments;
    protected final boolean mySearchInNonJavaFiles;
    private final PsiDirectory myNewParent;
    private final MoveCallback myMoveCallback;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final Map<PsiFile, List<UsageInfo>> myFoundUsages = new HashMap<PsiFile, List<UsageInfo>>();

    public MoveFilesOrDirectoriesProcessor(Project project2, PsiElement[] elements, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        this(project2, elements, newParent, true, searchInComments, searchInNonJavaFiles, moveCallback, prepareSuccessfulCallback);
    }

    public MoveFilesOrDirectoriesProcessor(Project project2, PsiElement[] elements, PsiDirectory newParent, boolean searchForReferences, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        super(project2, prepareSuccessfulCallback);
        this.myElementsToMove = elements;
        this.myNewParent = newParent;
        this.mySearchForReferences = searchForReferences;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor", "createUsageViewDescriptor"));
        }
        MoveFilesOrDirectoriesViewDescriptor moveFilesOrDirectoriesViewDescriptor = new MoveFilesOrDirectoriesViewDescriptor(this.myElementsToMove, this.myNewParent);
        if (moveFilesOrDirectoriesViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor", "createUsageViewDescriptor"));
        }
        return moveFilesOrDirectoriesViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (int i = 0; i < this.myElementsToMove.length; ++i) {
            PsiElement element = this.myElementsToMove[i];
            if (this.mySearchForReferences) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject))) {
                    result2.add(new MyUsageInfo(reference.getElement(), i, reference));
                }
            }
            this.findElementUsages(result2, element);
        }
        UsageInfo[] usageInfoArray = result2.toArray(new UsageInfo[result2.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private void findElementUsages(ArrayList<UsageInfo> result2, PsiElement element) {
        if (!this.mySearchForReferences) {
            return;
        }
        if (element instanceof PsiFile) {
            List<UsageInfo> usages = MoveFileHandler.forElement((PsiFile)element).findUsages((PsiFile)element, this.myNewParent, this.mySearchInComments, this.mySearchInNonJavaFiles);
            if (usages != null) {
                result2.addAll(usages);
                this.myFoundUsages.put((PsiFile)element, usages);
            }
        } else if (element instanceof PsiDirectory) {
            for (PsiElement childElement : element.getChildren()) {
                this.findElementUsages(result2, childElement);
            }
        }
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor", "performRefactoring"));
        }
        try {
            ArrayList<PsiFile> movedFiles = new ArrayList<PsiFile>();
            HashMap<PsiElement, PsiElement> oldToNewMap = new HashMap<PsiElement, PsiElement>();
            for (PsiElement element : this.myElementsToMove) {
                RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
                if (element instanceof PsiDirectory) {
                    MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)element, this.myNewParent);
                    for (PsiElement psiElement : element.getChildren()) {
                        this.processDirectoryFiles(movedFiles, oldToNewMap, psiElement);
                    }
                } else if (element instanceof PsiFile) {
                    PsiFile movedFile = (PsiFile)element;
                    if (this.mySearchForReferences) {
                        FileReferenceContextUtil.encodeFileReferences(element);
                    }
                    MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, this.myNewParent, oldToNewMap);
                    PsiFile moving = this.myNewParent.findFile(movedFile.getName());
                    if (moving == null) {
                        MoveFilesOrDirectoriesUtil.doMoveFile(movedFile, this.myNewParent);
                    }
                    moving = this.myNewParent.findFile(movedFile.getName());
                    movedFiles.add(moving);
                }
                elementListener.elementMoved(element);
            }
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            for (PsiFile movedFile : movedFiles) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                if (!this.mySearchForReferences) continue;
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            this.retargetUsages(usages, oldToNewMap);
            if (MoveFilesOrDirectoriesDialog.isOpenInEditor()) {
                EditorHelper.openFilesInEditor((PsiElement[])((PsiElement[])movedFiles.toArray(new PsiFile[movedFiles.size()])));
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }
        catch (IncorrectOperationException e) {
            int index;
            String message = e.getMessage();
            int n = index = message != null ? message.indexOf("java.io.IOException") : -1;
            if (index >= 0 && message != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    String cause = message.substring(index + "java.io.IOException".length());
                    Messages.showMessageDialog((Project)this.myProject, (String)cause, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                });
            }
            LOG.error((Throwable)e);
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElementsToMove);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myNewParent);
        return data;
    }

    private void processDirectoryFiles(List<PsiFile> movedFiles, Map<PsiElement, PsiElement> oldToNewMap, PsiElement psiElement) {
        if (psiElement instanceof PsiFile) {
            PsiFile movedFile = (PsiFile)psiElement;
            if (this.mySearchForReferences) {
                FileReferenceContextUtil.encodeFileReferences(psiElement);
            }
            MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, movedFile.getParent(), oldToNewMap);
            movedFiles.add(movedFile);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element : psiElement.getChildren()) {
                this.processDirectoryFiles(movedFiles, oldToNewMap, element);
            }
        }
    }

    protected void retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewMap) {
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usageInfo : usages) {
            if (usageInfo instanceof MyUsageInfo) {
                PsiElement refElement;
                PsiFile usageFile;
                PsiFile psiFile;
                PsiElement usageElement;
                MyUsageInfo info = (MyUsageInfo)usageInfo;
                PsiElement element = this.myElementsToMove[info.myIndex];
                if ((info.getReference() instanceof FileReference || info.getReference() instanceof PsiDynaReference) && (usageElement = info.getElement()) != null && (psiFile = (usageFile = usageElement.getContainingFile()).getViewProvider().getPsi(usageFile.getViewProvider().getBaseLanguage())) != null && psiFile.equals(element) || (refElement = info.myReference.getElement()) == null || !refElement.isValid()) continue;
                info.myReference.bindToElement(element);
                continue;
            }
            if (!(usageInfo instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usageInfo);
        }
        for (PsiFile movedFile : this.myFoundUsages.keySet()) {
            MoveFileHandler.forElement(movedFile).retargetUsages(this.myFoundUsages.get(movedFile), oldToNewMap);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.title");
    }

    static class MyUsageInfo
    extends UsageInfo {
        int myIndex;
        PsiReference myReference;

        public MyUsageInfo(PsiElement element, int index, PsiReference reference) {
            super(element);
            this.myIndex = index;
            this.myReference = reference;
        }
    }
}

