/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchUsageTarget;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import org.jetbrains.annotations.NotNull;

public class UsageViewContext {
    protected final SearchContext mySearchContext;
    protected final Configuration myConfiguration;
    private final ConfigurableUsageTarget myTarget;

    protected UsageViewContext(Configuration configuration, SearchContext searchContext, Runnable searchStarter) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
        this.myTarget = new StructuralSearchUsageTarget(configuration, searchContext, searchStarter);
    }

    public void setUsageView(UsageView usageView) {
    }

    public ConfigurableUsageTarget getTarget() {
        return this.myTarget;
    }

    public void configure(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/structuralsearch/plugin/ui/UsageViewContext", "configure"));
        }
        String pattern = this.myConfiguration.getMatchOptions().getSearchPattern();
        String scopeText = this.myConfiguration.getMatchOptions().getScope().getDisplayName();
        presentation.setScopeText(scopeText);
        String usagesString = SSRBundle.message("occurrences.of", pattern);
        presentation.setUsagesString(usagesString);
        presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)usagesString, (int)60, (int)0, (boolean)false));
        presentation.setUsagesWord(SSRBundle.message("occurrence", new Object[0]));
        presentation.setCodeUsagesString(SSRBundle.message("found.occurrences", scopeText));
        presentation.setTargetsNodeText(SSRBundle.message("targets.node.text", new Object[0]));
        presentation.setCodeUsages(false);
    }

    protected void configureActions() {
    }
}

