/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointActionsPanel
extends XBreakpointPropertiesSubPanel {
    public static final String LOG_EXPRESSION_HISTORY_ID = "breakpointLogExpression";
    private JCheckBox myLogMessageCheckBox;
    private JCheckBox myLogExpressionCheckBox;
    private JPanel myLogExpressionPanel;
    private JPanel myContentPane;
    private JPanel myMainPanel;
    private JCheckBox myTemporaryCheckBox;
    private JPanel myExpressionPanel;
    private XDebuggerExpressionComboBox myLogExpressionComboBox;

    public XBreakpointActionsPanel() {
        this.$$$setupUI$$$();
    }

    public void init(Project project2, XBreakpointManager breakpointManager, @NotNull XBreakpointBase breakpoint, @Nullable XDebuggerEditorsProvider debuggerEditorsProvider) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointActionsPanel", "init"));
        }
        this.init(project2, breakpointManager, breakpoint);
        if (debuggerEditorsProvider != null) {
            ActionListener listener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XBreakpointActionsPanel.this.onCheckboxChanged();
                }
            };
            this.myLogExpressionComboBox = new XDebuggerExpressionComboBox(project2, debuggerEditorsProvider, LOG_EXPRESSION_HISTORY_ID, this.myBreakpoint.getSourcePosition(), true);
            JComponent logExpressionComponent = this.myLogExpressionComboBox.getComponent();
            this.myLogExpressionPanel.add((Component)logExpressionComponent, "Center");
            this.myLogExpressionComboBox.setEnabled(false);
            this.myTemporaryCheckBox.setVisible(breakpoint instanceof XLineBreakpoint);
            this.myLogExpressionCheckBox.addActionListener(listener2);
            DebuggerUIUtil.focusEditorOnCheck(this.myLogExpressionCheckBox, this.myLogExpressionComboBox.getEditorComponent());
        } else {
            this.myExpressionPanel.getParent().remove(this.myExpressionPanel);
        }
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        if (!(showAllOptions || this.myBreakpoint.isLogMessage() || this.myBreakpoint.getLogExpression() != null || this.myBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)this.myBreakpoint).isTemporary())) {
            this.myMainPanel.setVisible(false);
            return true;
        }
        this.myMainPanel.setBorder(null);
        return false;
    }

    private void onCheckboxChanged() {
        if (this.myLogExpressionComboBox != null) {
            this.myLogExpressionComboBox.setEnabled(this.myLogExpressionCheckBox.isSelected());
        }
    }

    @Override
    void loadProperties() {
        this.myLogMessageCheckBox.setSelected(this.myBreakpoint.isLogMessage());
        if (this.myBreakpoint instanceof XLineBreakpoint) {
            this.myTemporaryCheckBox.setSelected(((XLineBreakpoint)this.myBreakpoint).isTemporary());
        }
        if (this.myLogExpressionComboBox != null) {
            XExpression logExpression = this.myBreakpoint.getLogExpressionObjectInt();
            this.myLogExpressionComboBox.setExpression(logExpression);
            this.myLogExpressionCheckBox.setSelected(this.myBreakpoint.isLogExpressionEnabled() && logExpression != null);
        }
        this.onCheckboxChanged();
    }

    @Override
    void saveProperties() {
        this.myBreakpoint.setLogMessage(this.myLogMessageCheckBox.isSelected());
        if (this.myBreakpoint instanceof XLineBreakpoint) {
            ((XLineBreakpoint)this.myBreakpoint).setTemporary(this.myTemporaryCheckBox.isSelected());
        }
        if (this.myLogExpressionComboBox != null) {
            XExpression expression = this.myLogExpressionComboBox.getExpression();
            XExpression logExpression = !XDebuggerUtilImpl.isEmptyExpression(expression) ? expression : null;
            this.myBreakpoint.setLogExpressionEnabled(logExpression == null || this.myLogExpressionCheckBox.isSelected());
            this.myBreakpoint.setLogExpressionObject(logExpression);
            this.myLogExpressionComboBox.saveTextInHistory();
        }
    }

    JComponent getDefaultFocusComponent() {
        if (this.myLogExpressionComboBox != null && this.myLogExpressionComboBox.getComboBox().isEnabled()) {
            return this.myLogExpressionComboBox.getEditorComponent();
        }
        return null;
    }

    public void dispose() {
    }

    public void hide() {
        this.myContentPane.setVisible(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myContentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.properties.actions.group.title"), (int)0, (int)0, null, null));
        this.myLogMessageCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.log.message.checkbox"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExpressionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLogExpressionCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.log.expression.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLogExpressionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myTemporaryCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remove once hit");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

