/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SetValueInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final JPanel myEditorPanel;
    private final XValueModifier myModifier;
    private final XValueNodeImpl myValueNode;

    private SetValueInplaceEditor(XValueNodeImpl node, @NotNull String nodeName) {
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor", "<init>"));
        }
        super(node, "setValue");
        this.myValueNode = node;
        this.myModifier = ((XValue)this.myValueNode.getValueContainer()).getModifier();
        this.myEditorPanel = new JPanel();
        this.myEditorPanel.setLayout(new BorderLayout(0, 0));
        SimpleColoredComponent nameLabel = new SimpleColoredComponent();
        nameLabel.setIcon(this.getNode().getIcon());
        nameLabel.append(nodeName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        XValuePresentation presentation = node.getValuePresentation();
        if (presentation != null) {
            XValuePresentationUtil.appendSeparator((ColoredTextContainer)nameLabel, presentation.getSeparator());
        }
        this.myEditorPanel.add((Component)nameLabel, "West");
        this.myEditorPanel.add((Component)this.myExpressionEditor.getComponent(), "Center");
    }

    public static void show(XValueNodeImpl node, @NotNull String nodeName) {
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor", "show"));
        }
        SetValueInplaceEditor editor = new SetValueInplaceEditor(node, nodeName);
        if (editor.myModifier != null) {
            editor.myModifier.calculateInitialValueEditorText(initialValue -> AppUIUtil.invokeOnEdt(() -> {
                if (editor.getTree().isShowing()) {
                    editor.show(initialValue);
                }
            }));
        } else {
            editor.show(null);
        }
    }

    private void show(String initialValue) {
        this.myExpressionEditor.setExpression(XExpressionImpl.fromText(initialValue));
        this.myExpressionEditor.selectAll();
        this.show();
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myEditorPanel;
    }

    @Override
    public void doOKAction() {
        if (this.myModifier == null) {
            return;
        }
        this.myExpressionEditor.saveTextInHistory();
        DebuggerUIUtil.setTreeNodeValue(this.myValueNode, this.myExpressionEditor.getExpression().getExpression(), (Consumer<String>)((Consumer)errorMessage -> {
            Editor editor = this.myExpressionEditor.getEditor();
            if (editor != null) {
                HintManager.getInstance().showErrorHint(editor, errorMessage);
            } else {
                Messages.showErrorDialog((Component)((Object)this.myTree), (String)errorMessage);
            }
        }));
        super.doOKAction();
    }
}

