/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "acceptElement"));
        }
        return e instanceof XmlTag && e.isValid();
    }

    public Language[] getLanguages() {
        return new Language[]{XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE, HTMLLanguage.INSTANCE};
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "getElementInfo"));
        }
        XmlTag tag = (XmlTag)e;
        boolean addHtmlInfo = e.getContainingFile().getLanguage() != XMLLanguage.INSTANCE;
        String string = addHtmlInfo ? HtmlUtil.getTagPresentation(tag) : tag.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "getElementInfo"));
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        XmlAttribute[] attributes;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "getElementTooltip"));
        }
        XmlTag tag = (XmlTag)e;
        StringBuilder result2 = new StringBuilder("&lt;");
        result2.append(tag.getName());
        for (XmlAttribute each : attributes = tag.getAttributes()) {
            result2.append(" ").append(each.getText());
        }
        if (tag.isEmpty()) {
            result2.append("/&gt;");
        } else {
            result2.append("&gt;...&lt;/").append(tag.getName()).append("&gt;");
        }
        return result2.toString();
    }
}

