/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterTypePreventsOverridingInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String qualifiedName1 = (String)infos[0];
        String packageName = StringUtil.getPackageName((String)qualifiedName1);
        String qualifiedName2 = (String)infos[1];
        String superPackageName = StringUtil.getPackageName((String)qualifiedName2);
        String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.problem.descriptor", packageName, superPackageName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ParameterTypePreventsOverridingFix((String)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterTypePreventsOverridingVisitor();
    }

    private static class ParameterTypePreventsOverridingVisitor
    extends BaseInspectionVisitor {
        private ParameterTypePreventsOverridingVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            super.visitMethod(method);
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiClass superClass = containingClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            String name = method.getName();
            block0: for (PsiMethod superMethod : superMethods = superClass.findMethodsByName(name, true)) {
                PsiType type;
                PsiParameterList superParameterList;
                PsiType superReturnType = superMethod.getReturnType();
                if (superReturnType == null || !superReturnType.isAssignableFrom(returnType) || (superParameterList = superMethod.getParameterList()).getParametersCount() != parameterCount) continue;
                PsiParameter[] superParameters = superParameterList.getParameters();
                Map problemTypeElements = ContainerUtilRt.newHashMap((int)2);
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter parameter = parameters[i];
                    PsiParameter superParameter = superParameters[i];
                    type = parameter.getType();
                    PsiType superType = superParameter.getType();
                    if (!(superType instanceof PsiClassType) || type.equals(superType)) continue;
                    if (!(type instanceof PsiClassType) || !type.getPresentableText().equals(superType.getPresentableText())) {
                        return;
                    }
                    PsiTypeElement typeElement = parameter.getTypeElement();
                    if (typeElement == null) {
                        return;
                    }
                    PsiTypeElement superParameterTypeElement = superParameter.getTypeElement();
                    if (superParameterTypeElement == null) continue block0;
                    problemTypeElements.put(typeElement, (PsiClassType)superType);
                }
                for (Map.Entry entry : problemTypeElements.entrySet()) {
                    PsiTypeElement typeElement = (PsiTypeElement)entry.getKey();
                    type = (PsiClassType)typeElement.getType();
                    PsiClass aClass1 = type.resolve();
                    if (aClass1 == null || aClass1 instanceof PsiTypeParameter) {
                        return;
                    }
                    PsiClassType classType = (PsiClassType)entry.getValue();
                    PsiClass aClass2 = classType.resolve();
                    if (aClass2 == null || aClass2 instanceof PsiTypeParameter) continue;
                    this.registerError((PsiElement)typeElement, type.getCanonicalText(), classType.getCanonicalText());
                }
            }
        }
    }

    private static class ParameterTypePreventsOverridingFix
    extends InspectionGadgetsFix {
        private final String myNewTypeText;

        public ParameterTypePreventsOverridingFix(String newTypeText) {
            this.myNewTypeText = newTypeText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.quickfix", this.myNewTypeText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection$ParameterTypePreventsOverridingFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection$ParameterTypePreventsOverridingFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)typeElement.getProject());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(this.myNewTypeText, (PsiElement)typeElement);
            typeElement.replace((PsiElement)newTypeElement);
        }
    }
}

