/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet nonThreadSafeClasses = new ExternalizableStringSet("java.text.SimpleDateFormat", "java.text.MessageFormat", "java.text.DecimalFormat", "java.text.ChoiceFormat", "java.util.Calendar");
    @NonNls
    public String nonThreadSafeTypes = "";

    public AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase() {
        if (!this.nonThreadSafeTypes.isEmpty()) {
            this.nonThreadSafeClasses.clear();
            List strings = StringUtil.split((String)this.nonThreadSafeTypes, (String)",");
            for (String string : strings) {
                this.nonThreadSafeClasses.add(string);
            }
            this.nonThreadSafeTypes = "";
        }
    }

    @NotNull
    public String getID() {
        if ("AccessToNonThreadSafeStaticField" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase", "getID"));
        }
        return "AccessToNonThreadSafeStaticField";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.field.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AccessToNonThreadSafeStaticFieldFromInstanceVisitor();
    }

    class AccessToNonThreadSafeStaticFieldFromInstanceVisitor
    extends BaseInspectionVisitor {
        AccessToNonThreadSafeStaticFieldFromInstanceVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement target;
            super.visitReferenceExpression(expression);
            if (expression.getQualifierExpression() != null) {
                return;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            String className = classType.rawType().getCanonicalText();
            boolean deepCheck = false;
            if (!AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.this.nonThreadSafeClasses.contains(className)) {
                if (!TypeUtils.isExpressionTypeAssignableWith((PsiExpression)expression, (Iterable<String>)((Object)AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.this.nonThreadSafeClasses))) {
                    return;
                }
                deepCheck = true;
            }
            if (!((target = expression.resolve()) instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiModifierListOwner parent = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiField.class, PsiMethod.class, PsiClassInitializer.class});
            if (parent == null) {
                return;
            }
            if (parent instanceof PsiMethod || parent instanceof PsiClassInitializer) {
                if (parent.hasModifierProperty("synchronized")) {
                    return;
                }
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiSynchronizedStatement.class);
                if (synchronizedStatement != null) {
                    return;
                }
            }
            if ((parent instanceof PsiField || parent instanceof PsiClassInitializer) && parent.hasModifierProperty("static")) {
                return;
            }
            if (deepCheck) {
                PsiExpression initializer = field.getInitializer();
                if (initializer == null) {
                    return;
                }
                PsiType initializerType = initializer.getType();
                if (!(initializerType instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType2 = (PsiClassType)initializerType;
                String className2 = classType2.rawType().getCanonicalText();
                if (!AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.this.nonThreadSafeClasses.contains(className2)) {
                    return;
                }
                this.registerError((PsiElement)expression, className2);
            } else {
                this.registerError((PsiElement)expression, className);
            }
        }
    }
}

