/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.types;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReplaceLambdaWithAnonymousIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceLambdaWithAnonymousIntention.class.getName()));

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        LambdaPredicate lambdaPredicate = new LambdaPredicate();
        if (lambdaPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/types/ReplaceLambdaWithAnonymousIntention", "getElementPredicate"));
        }
        return lambdaPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/types/ReplaceLambdaWithAnonymousIntention", "processIntention"));
        }
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/types/ReplaceLambdaWithAnonymousIntention", "processIntention"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
        LOG.assertTrue(lambdaExpression != null);
        PsiParameter[] paramListCopy = ((PsiParameterList)lambdaExpression.getParameterList().copy()).getParameters();
        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
        LOG.assertTrue(functionalInterfaceType != null);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        LOG.assertTrue(method != null);
        String blockText = ReplaceLambdaWithAnonymousIntention.getBodyText(lambdaExpression);
        if (blockText == null) {
            return;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiCodeBlock blockFromText = psiElementFactory.createCodeBlockFromText(blockText, (PsiElement)lambdaExpression);
        ReplaceLambdaWithAnonymousIntention.qualifyThisExpressions(lambdaExpression, psiElementFactory, blockFromText);
        blockFromText = psiElementFactory.createCodeBlockFromText(blockFromText.getText(), null);
        PsiNewExpression newExpression = (PsiNewExpression)psiElementFactory.createExpressionFromText("new " + functionalInterfaceType.getCanonicalText() + "(){}", (PsiElement)lambdaExpression);
        newExpression = (PsiNewExpression)JavaCodeStyleManager.getInstance((Project)lambdaExpression.getProject()).shortenClassReferences(lambdaExpression.replace((PsiElement)newExpression));
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        LOG.assertTrue(anonymousClass != null);
        List<PsiGenerationInfo<PsiMethod>> infos = OverrideImplementUtil.overrideOrImplement((PsiClass)anonymousClass, method);
        if (infos != null && infos.size() == 1) {
            PsiCodeBlock codeBlock;
            PsiMethod member = infos.get(0).getPsiMember();
            PsiParameter[] parameters = member.getParameterList().getParameters();
            if (parameters.length == paramListCopy.length) {
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter parameter = parameters[i];
                    String lambdaParamName = paramListCopy[i].getName();
                    if (lambdaParamName == null) continue;
                    parameter.setName(lambdaParamName);
                }
            }
            LOG.assertTrue((codeBlock = member.getBody()) != null);
            codeBlock = (PsiCodeBlock)codeBlock.replace((PsiElement)blockFromText);
            PsiElement parent = anonymousClass.getParent().getParent();
            if (parent instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)parent))) {
                PsiExpression operand = ((PsiTypeCastExpression)parent).getOperand();
                LOG.assertTrue(operand != null);
                PsiNewExpression expression = (PsiNewExpression)parent.replace((PsiElement)operand);
                PsiAnonymousClass simplifiedClass = expression.getAnonymousClass();
                LOG.assertTrue(simplifiedClass != null);
                member = simplifiedClass.getMethods()[0];
            }
            GenerateMembersUtil.positionCaret(editor, (PsiElement)member, true);
        }
    }

    private static void qualifyThisExpressions(PsiLambdaExpression lambdaExpression, PsiElementFactory psiElementFactory, PsiCodeBlock blockFromText) {
        String thisClassName;
        ChangeContextUtil.encodeContextInfo((PsiElement)blockFromText, true);
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)lambdaExpression);
        String string = thisClassName = thisClass != null ? thisClass.getName() : null;
        if (thisClassName != null) {
            PsiThisExpression thisAccessExpr = thisClass instanceof PsiAnonymousClass ? null : RefactoringChangeUtil.createThisExpression(lambdaExpression.getManager(), thisClass);
            ChangeContextUtil.decodeContextInfo((PsiElement)blockFromText, thisClass, (PsiExpression)thisAccessExpr);
            HashMap replacements = new HashMap();
            blockFromText.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)replacements, psiElementFactory, thisClassName, thisAccessExpr){
                final /* synthetic */ Map val$replacements;
                final /* synthetic */ PsiElementFactory val$psiElementFactory;
                final /* synthetic */ String val$thisClassName;
                final /* synthetic */ PsiThisExpression val$thisAccessExpr;
                {
                    this.val$replacements = map;
                    this.val$psiElementFactory = psiElementFactory;
                    this.val$thisClassName = string;
                    this.val$thisAccessExpr = psiThisExpression;
                }

                public void visitClass(PsiClass aClass) {
                }

                public void visitSuperExpression(PsiSuperExpression expression) {
                    super.visitSuperExpression(expression);
                    if (expression.getQualifier() == null) {
                        this.val$replacements.put(expression, this.val$psiElementFactory.createExpressionFromText(this.val$thisClassName + "." + expression.getText(), (PsiElement)expression));
                    }
                }

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    PsiMethod psiMethod;
                    super.visitMethodCallExpression(expression);
                    if (this.val$thisAccessExpr != null && (psiMethod = expression.resolveMethod()) != null && !psiMethod.hasModifierProperty("static") && expression.getMethodExpression().getQualifierExpression() == null) {
                        this.val$replacements.put(expression, this.val$psiElementFactory.createExpressionFromText(this.val$thisAccessExpr.getText() + "." + expression.getText(), (PsiElement)expression));
                    }
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get(psiElement));
            }
        }
    }

    private static String getBodyText(PsiLambdaExpression lambdaExpression) {
        String blockText;
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
            blockText = "{";
            blockText = blockText + (PsiType.VOID.equals((Object)returnType) ? "" : "return ");
            blockText = blockText + body.getText() + ";}";
        } else {
            blockText = body != null ? body.getText() : null;
        }
        return blockText;
    }

    private static class LambdaPredicate
    implements PsiElementPredicate {
        private LambdaPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            if (lambdaExpression != null && (element.getParent() == lambdaExpression && element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.ARROW || PsiTreeUtil.isAncestor((PsiElement)lambdaExpression.getParameterList(), (PsiElement)element, (boolean)false))) {
                PsiMethod interfaceMethod;
                PsiType functionalInterfaceType;
                PsiClass thisClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiClass.class, (boolean)true);
                if (thisClass == null || thisClass instanceof PsiAnonymousClass) {
                    PsiElement body = lambdaExpression.getBody();
                    if (body == null) {
                        return false;
                    }
                    final boolean[] disabled = new boolean[1];
                    body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitThisExpression(PsiThisExpression expression) {
                            disabled[0] = true;
                        }

                        public void visitSuperExpression(PsiSuperExpression expression) {
                            disabled[0] = true;
                        }
                    });
                    if (disabled[0]) {
                        return false;
                    }
                }
                if ((functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType()) != null && LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)functionalInterfaceType) && LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType)) != null) {
                    PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
                    for (PsiType type : interfaceMethod.getSignature(substitutor).getParameterTypes()) {
                        if (PsiTypesUtil.isDenotableType((PsiType)type)) continue;
                        return false;
                    }
                    PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                    return PsiTypesUtil.isDenotableType((PsiType)returnType);
                }
            }
            return false;
        }
    }
}

